package zio.aws.migrationhuborchestrator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.migrationhuborchestrator.model.primitives.StringListMember
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class TemplateStepGroupSummary(
    id: Optional[String] = Optional.Absent,
    name: Optional[String] = Optional.Absent,
    previous: Optional[Iterable[StringListMember]] = Optional.Absent,
    next: Optional[Iterable[StringListMember]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhuborchestrator.model.TemplateStepGroupSummary = {
    import TemplateStepGroupSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhuborchestrator.model.TemplateStepGroupSummary
      .builder()
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(
        previous.map(value =>
          value.map { item =>
            StringListMember.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.previous)
      .optionallyWith(
        next.map(value =>
          value.map { item =>
            StringListMember.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.next)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhuborchestrator.model.TemplateStepGroupSummary.ReadOnly =
    zio.aws.migrationhuborchestrator.model.TemplateStepGroupSummary
      .wrap(buildAwsValue())
}
object TemplateStepGroupSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhuborchestrator.model.TemplateStepGroupSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhuborchestrator.model.TemplateStepGroupSummary =
      zio.aws.migrationhuborchestrator.model.TemplateStepGroupSummary(
        id.map(value => value),
        name.map(value => value),
        previous.map(value => value),
        next.map(value => value)
      )
    def id: Optional[String]
    def name: Optional[String]
    def previous: Optional[List[StringListMember]]
    def next: Optional[List[StringListMember]]
    def getId: ZIO[Any, AwsError, String] = AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getPrevious: ZIO[Any, AwsError, List[StringListMember]] =
      AwsError.unwrapOptionField("previous", previous)
    def getNext: ZIO[Any, AwsError, List[StringListMember]] =
      AwsError.unwrapOptionField("next", next)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.TemplateStepGroupSummary
  ) extends zio.aws.migrationhuborchestrator.model.TemplateStepGroupSummary.ReadOnly {
    override val id: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => value: String)
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val previous: Optional[List[StringListMember]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.previous())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.migrationhuborchestrator.model.primitives
              .StringListMember(item)
          }.toList
        )
    override val next: Optional[List[StringListMember]] = zio.aws.core.internal
      .optionalFromNullable(impl.next())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.migrationhuborchestrator.model.primitives
            .StringListMember(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.TemplateStepGroupSummary
  ): zio.aws.migrationhuborchestrator.model.TemplateStepGroupSummary.ReadOnly =
    new Wrapper(impl)
}
