package zio.aws.migrationhuborchestrator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.migrationhuborchestrator.model.primitives.{
  StringListMember,
  StringValue,
  Integer
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class WorkflowStepOutputUnion(
    integerValue: Optional[Integer] = Optional.Absent,
    stringValue: Optional[StringValue] = Optional.Absent,
    listOfStringValue: Optional[Iterable[StringListMember]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhuborchestrator.model.WorkflowStepOutputUnion = {
    import WorkflowStepOutputUnion.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhuborchestrator.model.WorkflowStepOutputUnion
      .builder()
      .optionallyWith(integerValue.map(value => value: java.lang.Integer))(
        _.integerValue
      )
      .optionallyWith(
        stringValue.map(value => StringValue.unwrap(value): java.lang.String)
      )(_.stringValue)
      .optionallyWith(
        listOfStringValue.map(value =>
          value.map { item =>
            StringListMember.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.listOfStringValue)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhuborchestrator.model.WorkflowStepOutputUnion.ReadOnly =
    zio.aws.migrationhuborchestrator.model.WorkflowStepOutputUnion
      .wrap(buildAwsValue())
}
object WorkflowStepOutputUnion {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhuborchestrator.model.WorkflowStepOutputUnion
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhuborchestrator.model.WorkflowStepOutputUnion =
      zio.aws.migrationhuborchestrator.model.WorkflowStepOutputUnion(
        integerValue.map(value => value),
        stringValue.map(value => value),
        listOfStringValue.map(value => value)
      )
    def integerValue: Optional[Integer]
    def stringValue: Optional[StringValue]
    def listOfStringValue: Optional[List[StringListMember]]
    def getIntegerValue: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("integerValue", integerValue)
    def getStringValue: ZIO[Any, AwsError, StringValue] =
      AwsError.unwrapOptionField("stringValue", stringValue)
    def getListOfStringValue: ZIO[Any, AwsError, List[StringListMember]] =
      AwsError.unwrapOptionField("listOfStringValue", listOfStringValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.WorkflowStepOutputUnion
  ) extends zio.aws.migrationhuborchestrator.model.WorkflowStepOutputUnion.ReadOnly {
    override val integerValue: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.integerValue())
      .map(value => value: Integer)
    override val stringValue: Optional[StringValue] = zio.aws.core.internal
      .optionalFromNullable(impl.stringValue())
      .map(value =>
        zio.aws.migrationhuborchestrator.model.primitives.StringValue(value)
      )
    override val listOfStringValue: Optional[List[StringListMember]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.listOfStringValue())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.migrationhuborchestrator.model.primitives
              .StringListMember(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.WorkflowStepOutputUnion
  ): zio.aws.migrationhuborchestrator.model.WorkflowStepOutputUnion.ReadOnly =
    new Wrapper(impl)
}
