package zio.aws.migrationhuborchestrator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.migrationhuborchestrator.model.primitives.{
  PluginVersion,
  IPAddress,
  PluginId
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PluginSummary(
    pluginId: Optional[PluginId] = Optional.Absent,
    hostname: Optional[String] = Optional.Absent,
    status: Optional[zio.aws.migrationhuborchestrator.model.PluginHealth] =
      Optional.Absent,
    ipAddress: Optional[IPAddress] = Optional.Absent,
    version: Optional[PluginVersion] = Optional.Absent,
    registeredTime: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhuborchestrator.model.PluginSummary = {
    import PluginSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhuborchestrator.model.PluginSummary
      .builder()
      .optionallyWith(
        pluginId.map(value => PluginId.unwrap(value): java.lang.String)
      )(_.pluginId)
      .optionallyWith(hostname.map(value => value: java.lang.String))(
        _.hostname
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        ipAddress.map(value => IPAddress.unwrap(value): java.lang.String)
      )(_.ipAddress)
      .optionallyWith(
        version.map(value => PluginVersion.unwrap(value): java.lang.String)
      )(_.version)
      .optionallyWith(registeredTime.map(value => value: java.lang.String))(
        _.registeredTime
      )
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhuborchestrator.model.PluginSummary.ReadOnly =
    zio.aws.migrationhuborchestrator.model.PluginSummary.wrap(buildAwsValue())
}
object PluginSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhuborchestrator.model.PluginSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.migrationhuborchestrator.model.PluginSummary =
      zio.aws.migrationhuborchestrator.model.PluginSummary(
        pluginId.map(value => value),
        hostname.map(value => value),
        status.map(value => value),
        ipAddress.map(value => value),
        version.map(value => value),
        registeredTime.map(value => value)
      )
    def pluginId: Optional[PluginId]
    def hostname: Optional[String]
    def status: Optional[zio.aws.migrationhuborchestrator.model.PluginHealth]
    def ipAddress: Optional[IPAddress]
    def version: Optional[PluginVersion]
    def registeredTime: Optional[String]
    def getPluginId: ZIO[Any, AwsError, PluginId] =
      AwsError.unwrapOptionField("pluginId", pluginId)
    def getHostname: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("hostname", hostname)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.migrationhuborchestrator.model.PluginHealth
    ] = AwsError.unwrapOptionField("status", status)
    def getIpAddress: ZIO[Any, AwsError, IPAddress] =
      AwsError.unwrapOptionField("ipAddress", ipAddress)
    def getVersion: ZIO[Any, AwsError, PluginVersion] =
      AwsError.unwrapOptionField("version", version)
    def getRegisteredTime: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("registeredTime", registeredTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.PluginSummary
  ) extends zio.aws.migrationhuborchestrator.model.PluginSummary.ReadOnly {
    override val pluginId: Optional[PluginId] = zio.aws.core.internal
      .optionalFromNullable(impl.pluginId())
      .map(value =>
        zio.aws.migrationhuborchestrator.model.primitives.PluginId(value)
      )
    override val hostname: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.hostname())
      .map(value => value: String)
    override val status
        : Optional[zio.aws.migrationhuborchestrator.model.PluginHealth] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.migrationhuborchestrator.model.PluginHealth.wrap(value)
        )
    override val ipAddress: Optional[IPAddress] = zio.aws.core.internal
      .optionalFromNullable(impl.ipAddress())
      .map(value =>
        zio.aws.migrationhuborchestrator.model.primitives.IPAddress(value)
      )
    override val version: Optional[PluginVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value =>
        zio.aws.migrationhuborchestrator.model.primitives.PluginVersion(value)
      )
    override val registeredTime: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.registeredTime())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.PluginSummary
  ): zio.aws.migrationhuborchestrator.model.PluginSummary.ReadOnly =
    new Wrapper(impl)
}
