package zio.aws.migrationhuborchestrator.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.migrationhuborchestrator.model.primitives.{
  StepGroupId,
  MigrationWorkflowId
}
import scala.jdk.CollectionConverters.*
final case class DeleteWorkflowStepGroupRequest(
    workflowId: MigrationWorkflowId,
    id: StepGroupId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhuborchestrator.model.DeleteWorkflowStepGroupRequest = {
    import DeleteWorkflowStepGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhuborchestrator.model.DeleteWorkflowStepGroupRequest
      .builder()
      .workflowId(MigrationWorkflowId.unwrap(workflowId): java.lang.String)
      .id(StepGroupId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhuborchestrator.model.DeleteWorkflowStepGroupRequest.ReadOnly =
    zio.aws.migrationhuborchestrator.model.DeleteWorkflowStepGroupRequest
      .wrap(buildAwsValue())
}
object DeleteWorkflowStepGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhuborchestrator.model.DeleteWorkflowStepGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhuborchestrator.model.DeleteWorkflowStepGroupRequest =
      zio.aws.migrationhuborchestrator.model
        .DeleteWorkflowStepGroupRequest(workflowId, id)
    def workflowId: MigrationWorkflowId
    def id: StepGroupId
    def getWorkflowId: ZIO[Any, Nothing, MigrationWorkflowId] =
      ZIO.succeed(workflowId)
    def getId: ZIO[Any, Nothing, StepGroupId] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.DeleteWorkflowStepGroupRequest
  ) extends zio.aws.migrationhuborchestrator.model.DeleteWorkflowStepGroupRequest.ReadOnly {
    override val workflowId: MigrationWorkflowId =
      zio.aws.migrationhuborchestrator.model.primitives
        .MigrationWorkflowId(impl.workflowId())
    override val id: StepGroupId =
      zio.aws.migrationhuborchestrator.model.primitives.StepGroupId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.DeleteWorkflowStepGroupRequest
  ): zio.aws.migrationhuborchestrator.model.DeleteWorkflowStepGroupRequest.ReadOnly =
    new Wrapper(impl)
}
