package zio.aws.migrationhuborchestrator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.migrationhuborchestrator.model.primitives.{
  StringListMember,
  MigrationWorkflowId,
  StepGroupName,
  StepGroupDescription,
  StepGroupId
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateWorkflowStepGroupRequest(
    workflowId: MigrationWorkflowId,
    id: StepGroupId,
    name: Optional[StepGroupName] = Optional.Absent,
    description: Optional[StepGroupDescription] = Optional.Absent,
    next: Optional[Iterable[StringListMember]] = Optional.Absent,
    previous: Optional[Iterable[StringListMember]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhuborchestrator.model.UpdateWorkflowStepGroupRequest = {
    import UpdateWorkflowStepGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhuborchestrator.model.UpdateWorkflowStepGroupRequest
      .builder()
      .workflowId(MigrationWorkflowId.unwrap(workflowId): java.lang.String)
      .id(StepGroupId.unwrap(id): java.lang.String)
      .optionallyWith(
        name.map(value => StepGroupName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          StepGroupDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        next.map(value =>
          value.map { item =>
            StringListMember.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.next)
      .optionallyWith(
        previous.map(value =>
          value.map { item =>
            StringListMember.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.previous)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhuborchestrator.model.UpdateWorkflowStepGroupRequest.ReadOnly =
    zio.aws.migrationhuborchestrator.model.UpdateWorkflowStepGroupRequest
      .wrap(buildAwsValue())
}
object UpdateWorkflowStepGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhuborchestrator.model.UpdateWorkflowStepGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhuborchestrator.model.UpdateWorkflowStepGroupRequest =
      zio.aws.migrationhuborchestrator.model.UpdateWorkflowStepGroupRequest(
        workflowId,
        id,
        name.map(value => value),
        description.map(value => value),
        next.map(value => value),
        previous.map(value => value)
      )
    def workflowId: MigrationWorkflowId
    def id: StepGroupId
    def name: Optional[StepGroupName]
    def description: Optional[StepGroupDescription]
    def next: Optional[List[StringListMember]]
    def previous: Optional[List[StringListMember]]
    def getWorkflowId: ZIO[Any, Nothing, MigrationWorkflowId] =
      ZIO.succeed(workflowId)
    def getId: ZIO[Any, Nothing, StepGroupId] = ZIO.succeed(id)
    def getName: ZIO[Any, AwsError, StepGroupName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, StepGroupDescription] =
      AwsError.unwrapOptionField("description", description)
    def getNext: ZIO[Any, AwsError, List[StringListMember]] =
      AwsError.unwrapOptionField("next", next)
    def getPrevious: ZIO[Any, AwsError, List[StringListMember]] =
      AwsError.unwrapOptionField("previous", previous)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.UpdateWorkflowStepGroupRequest
  ) extends zio.aws.migrationhuborchestrator.model.UpdateWorkflowStepGroupRequest.ReadOnly {
    override val workflowId: MigrationWorkflowId =
      zio.aws.migrationhuborchestrator.model.primitives
        .MigrationWorkflowId(impl.workflowId())
    override val id: StepGroupId =
      zio.aws.migrationhuborchestrator.model.primitives.StepGroupId(impl.id())
    override val name: Optional[StepGroupName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.migrationhuborchestrator.model.primitives.StepGroupName(value)
      )
    override val description: Optional[StepGroupDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.migrationhuborchestrator.model.primitives
            .StepGroupDescription(value)
        )
    override val next: Optional[List[StringListMember]] = zio.aws.core.internal
      .optionalFromNullable(impl.next())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.migrationhuborchestrator.model.primitives
            .StringListMember(item)
        }.toList
      )
    override val previous: Optional[List[StringListMember]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.previous())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.migrationhuborchestrator.model.primitives
              .StringListMember(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.UpdateWorkflowStepGroupRequest
  ): zio.aws.migrationhuborchestrator.model.UpdateWorkflowStepGroupRequest.ReadOnly =
    new Wrapper(impl)
}
