package zio.aws.migrationhuborchestrator.model
import zio.prelude.data.Optional
import zio.aws.migrationhuborchestrator.model.primitives.{
  TemplateName,
  NextToken,
  MaxResults
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListTemplatesRequest(
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    name: Optional[TemplateName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhuborchestrator.model.ListTemplatesRequest = {
    import ListTemplatesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhuborchestrator.model.ListTemplatesRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        name.map(value => TemplateName.unwrap(value): java.lang.String)
      )(_.name)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhuborchestrator.model.ListTemplatesRequest.ReadOnly =
    zio.aws.migrationhuborchestrator.model.ListTemplatesRequest
      .wrap(buildAwsValue())
}
object ListTemplatesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhuborchestrator.model.ListTemplatesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhuborchestrator.model.ListTemplatesRequest =
      zio.aws.migrationhuborchestrator.model.ListTemplatesRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        name.map(value => value)
      )
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def name: Optional[TemplateName]
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getName: ZIO[Any, AwsError, TemplateName] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.ListTemplatesRequest
  ) extends zio.aws.migrationhuborchestrator.model.ListTemplatesRequest.ReadOnly {
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value =>
        zio.aws.migrationhuborchestrator.model.primitives.MaxResults(value)
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.migrationhuborchestrator.model.primitives.NextToken(value)
      )
    override val name: Optional[TemplateName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.migrationhuborchestrator.model.primitives.TemplateName(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.ListTemplatesRequest
  ): zio.aws.migrationhuborchestrator.model.ListTemplatesRequest.ReadOnly =
    new Wrapper(impl)
}
