package zio.aws.migrationhuborchestrator.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.migrationhuborchestrator.model.primitives.{
  MigrationWorkflowId,
  StepGroupId,
  StepId
}
import scala.jdk.CollectionConverters.*
final case class DeleteWorkflowStepRequest(
    id: StepId,
    stepGroupId: StepGroupId,
    workflowId: MigrationWorkflowId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhuborchestrator.model.DeleteWorkflowStepRequest = {
    import DeleteWorkflowStepRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhuborchestrator.model.DeleteWorkflowStepRequest
      .builder()
      .id(StepId.unwrap(id): java.lang.String)
      .stepGroupId(StepGroupId.unwrap(stepGroupId): java.lang.String)
      .workflowId(MigrationWorkflowId.unwrap(workflowId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhuborchestrator.model.DeleteWorkflowStepRequest.ReadOnly =
    zio.aws.migrationhuborchestrator.model.DeleteWorkflowStepRequest
      .wrap(buildAwsValue())
}
object DeleteWorkflowStepRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhuborchestrator.model.DeleteWorkflowStepRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhuborchestrator.model.DeleteWorkflowStepRequest =
      zio.aws.migrationhuborchestrator.model
        .DeleteWorkflowStepRequest(id, stepGroupId, workflowId)
    def id: StepId
    def stepGroupId: StepGroupId
    def workflowId: MigrationWorkflowId
    def getId: ZIO[Any, Nothing, StepId] = ZIO.succeed(id)
    def getStepGroupId: ZIO[Any, Nothing, StepGroupId] =
      ZIO.succeed(stepGroupId)
    def getWorkflowId: ZIO[Any, Nothing, MigrationWorkflowId] =
      ZIO.succeed(workflowId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.DeleteWorkflowStepRequest
  ) extends zio.aws.migrationhuborchestrator.model.DeleteWorkflowStepRequest.ReadOnly {
    override val id: StepId =
      zio.aws.migrationhuborchestrator.model.primitives.StepId(impl.id())
    override val stepGroupId: StepGroupId =
      zio.aws.migrationhuborchestrator.model.primitives
        .StepGroupId(impl.stepGroupId())
    override val workflowId: MigrationWorkflowId =
      zio.aws.migrationhuborchestrator.model.primitives
        .MigrationWorkflowId(impl.workflowId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.DeleteWorkflowStepRequest
  ): zio.aws.migrationhuborchestrator.model.DeleteWorkflowStepRequest.ReadOnly =
    new Wrapper(impl)
}
