package zio.aws.migrationhuborchestrator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class StepOutput(
    name: Optional[String] = Optional.Absent,
    dataType: Optional[zio.aws.migrationhuborchestrator.model.DataType] =
      Optional.Absent,
    required: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhuborchestrator.model.StepOutput = {
    import StepOutput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhuborchestrator.model.StepOutput
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(dataType.map(value => value.unwrap))(_.dataType)
      .optionallyWith(required.map(value => value: java.lang.Boolean))(
        _.required
      )
      .build()
  }
  def asReadOnly: zio.aws.migrationhuborchestrator.model.StepOutput.ReadOnly =
    zio.aws.migrationhuborchestrator.model.StepOutput.wrap(buildAwsValue())
}
object StepOutput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhuborchestrator.model.StepOutput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.migrationhuborchestrator.model.StepOutput =
      zio.aws.migrationhuborchestrator.model.StepOutput(
        name.map(value => value),
        dataType.map(value => value),
        required.map(value => value)
      )
    def name: Optional[String]
    def dataType: Optional[zio.aws.migrationhuborchestrator.model.DataType]
    def required: Optional[Boolean]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getDataType
        : ZIO[Any, AwsError, zio.aws.migrationhuborchestrator.model.DataType] =
      AwsError.unwrapOptionField("dataType", dataType)
    def getRequired: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("required", required)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.StepOutput
  ) extends zio.aws.migrationhuborchestrator.model.StepOutput.ReadOnly {
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val dataType
        : Optional[zio.aws.migrationhuborchestrator.model.DataType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataType())
        .map(value =>
          zio.aws.migrationhuborchestrator.model.DataType.wrap(value)
        )
    override val required: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.required())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.StepOutput
  ): zio.aws.migrationhuborchestrator.model.StepOutput.ReadOnly = new Wrapper(
    impl
  )
}
