package zio.aws.migrationhuborchestrator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RetryWorkflowStepResponse(
    stepGroupId: Optional[String] = Optional.Absent,
    workflowId: Optional[String] = Optional.Absent,
    id: Optional[String] = Optional.Absent,
    status: Optional[zio.aws.migrationhuborchestrator.model.StepStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhuborchestrator.model.RetryWorkflowStepResponse = {
    import RetryWorkflowStepResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhuborchestrator.model.RetryWorkflowStepResponse
      .builder()
      .optionallyWith(stepGroupId.map(value => value: java.lang.String))(
        _.stepGroupId
      )
      .optionallyWith(workflowId.map(value => value: java.lang.String))(
        _.workflowId
      )
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhuborchestrator.model.RetryWorkflowStepResponse.ReadOnly =
    zio.aws.migrationhuborchestrator.model.RetryWorkflowStepResponse
      .wrap(buildAwsValue())
}
object RetryWorkflowStepResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhuborchestrator.model.RetryWorkflowStepResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhuborchestrator.model.RetryWorkflowStepResponse =
      zio.aws.migrationhuborchestrator.model.RetryWorkflowStepResponse(
        stepGroupId.map(value => value),
        workflowId.map(value => value),
        id.map(value => value),
        status.map(value => value)
      )
    def stepGroupId: Optional[String]
    def workflowId: Optional[String]
    def id: Optional[String]
    def status: Optional[zio.aws.migrationhuborchestrator.model.StepStatus]
    def getStepGroupId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("stepGroupId", stepGroupId)
    def getWorkflowId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("workflowId", workflowId)
    def getId: ZIO[Any, AwsError, String] = AwsError.unwrapOptionField("id", id)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.migrationhuborchestrator.model.StepStatus
    ] = AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.RetryWorkflowStepResponse
  ) extends zio.aws.migrationhuborchestrator.model.RetryWorkflowStepResponse.ReadOnly {
    override val stepGroupId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.stepGroupId())
      .map(value => value: String)
    override val workflowId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.workflowId())
      .map(value => value: String)
    override val id: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => value: String)
    override val status
        : Optional[zio.aws.migrationhuborchestrator.model.StepStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.migrationhuborchestrator.model.StepStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.RetryWorkflowStepResponse
  ): zio.aws.migrationhuborchestrator.model.RetryWorkflowStepResponse.ReadOnly =
    new Wrapper(impl)
}
