package zio.aws.migrationhuborchestrator.model
import zio.prelude.data.Optional
import zio.aws.migrationhuborchestrator.model.primitives.{
  StepGroupId,
  MigrationWorkflowId,
  MaxResults,
  NextToken
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListWorkflowStepsRequest(
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    workflowId: MigrationWorkflowId,
    stepGroupId: StepGroupId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhuborchestrator.model.ListWorkflowStepsRequest = {
    import ListWorkflowStepsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhuborchestrator.model.ListWorkflowStepsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .workflowId(MigrationWorkflowId.unwrap(workflowId): java.lang.String)
      .stepGroupId(StepGroupId.unwrap(stepGroupId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhuborchestrator.model.ListWorkflowStepsRequest.ReadOnly =
    zio.aws.migrationhuborchestrator.model.ListWorkflowStepsRequest
      .wrap(buildAwsValue())
}
object ListWorkflowStepsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhuborchestrator.model.ListWorkflowStepsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhuborchestrator.model.ListWorkflowStepsRequest =
      zio.aws.migrationhuborchestrator.model.ListWorkflowStepsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        workflowId,
        stepGroupId
      )
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def workflowId: MigrationWorkflowId
    def stepGroupId: StepGroupId
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getWorkflowId: ZIO[Any, Nothing, MigrationWorkflowId] =
      ZIO.succeed(workflowId)
    def getStepGroupId: ZIO[Any, Nothing, StepGroupId] =
      ZIO.succeed(stepGroupId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.ListWorkflowStepsRequest
  ) extends zio.aws.migrationhuborchestrator.model.ListWorkflowStepsRequest.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.migrationhuborchestrator.model.primitives.NextToken(value)
      )
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value =>
        zio.aws.migrationhuborchestrator.model.primitives.MaxResults(value)
      )
    override val workflowId: MigrationWorkflowId =
      zio.aws.migrationhuborchestrator.model.primitives
        .MigrationWorkflowId(impl.workflowId())
    override val stepGroupId: StepGroupId =
      zio.aws.migrationhuborchestrator.model.primitives
        .StepGroupId(impl.stepGroupId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.ListWorkflowStepsRequest
  ): zio.aws.migrationhuborchestrator.model.ListWorkflowStepsRequest.ReadOnly =
    new Wrapper(impl)
}
