package zio.aws.migrationhuborchestrator.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.migrationhuborchestrator.model.primitives.{
  MigrationWorkflowId,
  StepGroupId
}
import scala.jdk.CollectionConverters.*
final case class GetWorkflowStepGroupRequest(
    id: StepGroupId,
    workflowId: MigrationWorkflowId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhuborchestrator.model.GetWorkflowStepGroupRequest = {
    import GetWorkflowStepGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhuborchestrator.model.GetWorkflowStepGroupRequest
      .builder()
      .id(StepGroupId.unwrap(id): java.lang.String)
      .workflowId(MigrationWorkflowId.unwrap(workflowId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhuborchestrator.model.GetWorkflowStepGroupRequest.ReadOnly =
    zio.aws.migrationhuborchestrator.model.GetWorkflowStepGroupRequest
      .wrap(buildAwsValue())
}
object GetWorkflowStepGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhuborchestrator.model.GetWorkflowStepGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhuborchestrator.model.GetWorkflowStepGroupRequest =
      zio.aws.migrationhuborchestrator.model
        .GetWorkflowStepGroupRequest(id, workflowId)
    def id: StepGroupId
    def workflowId: MigrationWorkflowId
    def getId: ZIO[Any, Nothing, StepGroupId] = ZIO.succeed(id)
    def getWorkflowId: ZIO[Any, Nothing, MigrationWorkflowId] =
      ZIO.succeed(workflowId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.GetWorkflowStepGroupRequest
  ) extends zio.aws.migrationhuborchestrator.model.GetWorkflowStepGroupRequest.ReadOnly {
    override val id: StepGroupId =
      zio.aws.migrationhuborchestrator.model.primitives.StepGroupId(impl.id())
    override val workflowId: MigrationWorkflowId =
      zio.aws.migrationhuborchestrator.model.primitives
        .MigrationWorkflowId(impl.workflowId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.GetWorkflowStepGroupRequest
  ): zio.aws.migrationhuborchestrator.model.GetWorkflowStepGroupRequest.ReadOnly =
    new Wrapper(impl)
}
