package zio.aws.migrationhuborchestrator.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.migrationhuborchestrator.model.primitives.Timestamp
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class GetTemplateResponse(
    id: Optional[String] = Optional.Absent,
    name: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    inputs: Optional[
      Iterable[zio.aws.migrationhuborchestrator.model.TemplateInput]
    ] = Optional.Absent,
    tools: Optional[Iterable[zio.aws.migrationhuborchestrator.model.Tool]] =
      Optional.Absent,
    status: Optional[zio.aws.migrationhuborchestrator.model.TemplateStatus] =
      Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhuborchestrator.model.GetTemplateResponse = {
    import GetTemplateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhuborchestrator.model.GetTemplateResponse
      .builder()
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        inputs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.inputs)
      .optionallyWith(
        tools.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tools)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhuborchestrator.model.GetTemplateResponse.ReadOnly =
    zio.aws.migrationhuborchestrator.model.GetTemplateResponse
      .wrap(buildAwsValue())
}
object GetTemplateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhuborchestrator.model.GetTemplateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.migrationhuborchestrator.model.GetTemplateResponse =
      zio.aws.migrationhuborchestrator.model.GetTemplateResponse(
        id.map(value => value),
        name.map(value => value),
        description.map(value => value),
        inputs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tools.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        status.map(value => value),
        creationTime.map(value => value)
      )
    def id: Optional[String]
    def name: Optional[String]
    def description: Optional[String]
    def inputs: Optional[
      List[zio.aws.migrationhuborchestrator.model.TemplateInput.ReadOnly]
    ]
    def tools
        : Optional[List[zio.aws.migrationhuborchestrator.model.Tool.ReadOnly]]
    def status: Optional[zio.aws.migrationhuborchestrator.model.TemplateStatus]
    def creationTime: Optional[Timestamp]
    def getId: ZIO[Any, AwsError, String] = AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getInputs: ZIO[Any, AwsError, List[
      zio.aws.migrationhuborchestrator.model.TemplateInput.ReadOnly
    ]] = AwsError.unwrapOptionField("inputs", inputs)
    def getTools: ZIO[Any, AwsError, List[
      zio.aws.migrationhuborchestrator.model.Tool.ReadOnly
    ]] = AwsError.unwrapOptionField("tools", tools)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.migrationhuborchestrator.model.TemplateStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.GetTemplateResponse
  ) extends zio.aws.migrationhuborchestrator.model.GetTemplateResponse.ReadOnly {
    override val id: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => value: String)
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val inputs: Optional[
      List[zio.aws.migrationhuborchestrator.model.TemplateInput.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.inputs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.migrationhuborchestrator.model.TemplateInput.wrap(item)
        }.toList
      )
    override val tools
        : Optional[List[zio.aws.migrationhuborchestrator.model.Tool.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tools())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.migrationhuborchestrator.model.Tool.wrap(item)
          }.toList
        )
    override val status
        : Optional[zio.aws.migrationhuborchestrator.model.TemplateStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.migrationhuborchestrator.model.TemplateStatus.wrap(value)
        )
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value =>
        zio.aws.migrationhuborchestrator.model.primitives.Timestamp(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.GetTemplateResponse
  ): zio.aws.migrationhuborchestrator.model.GetTemplateResponse.ReadOnly =
    new Wrapper(impl)
}
