package zio.aws.migrationhuborchestrator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.migrationhuborchestrator.model.primitives.{
  StringListMember,
  TemplateId,
  StepGroupId,
  StepId
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetTemplateStepResponse(
    id: Optional[StepId] = Optional.Absent,
    stepGroupId: Optional[StepGroupId] = Optional.Absent,
    templateId: Optional[TemplateId] = Optional.Absent,
    name: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    stepActionType: Optional[
      zio.aws.migrationhuborchestrator.model.StepActionType
    ] = Optional.Absent,
    creationTime: Optional[String] = Optional.Absent,
    previous: Optional[Iterable[StringListMember]] = Optional.Absent,
    next: Optional[Iterable[StringListMember]] = Optional.Absent,
    outputs: Optional[
      Iterable[zio.aws.migrationhuborchestrator.model.StepOutput]
    ] = Optional.Absent,
    stepAutomationConfiguration: Optional[
      zio.aws.migrationhuborchestrator.model.StepAutomationConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhuborchestrator.model.GetTemplateStepResponse = {
    import GetTemplateStepResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhuborchestrator.model.GetTemplateStepResponse
      .builder()
      .optionallyWith(id.map(value => StepId.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(
        stepGroupId.map(value => StepGroupId.unwrap(value): java.lang.String)
      )(_.stepGroupId)
      .optionallyWith(
        templateId.map(value => TemplateId.unwrap(value): java.lang.String)
      )(_.templateId)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(stepActionType.map(value => value.unwrap))(
        _.stepActionType
      )
      .optionallyWith(creationTime.map(value => value: java.lang.String))(
        _.creationTime
      )
      .optionallyWith(
        previous.map(value =>
          value.map { item =>
            StringListMember.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.previous)
      .optionallyWith(
        next.map(value =>
          value.map { item =>
            StringListMember.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.next)
      .optionallyWith(
        outputs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.outputs)
      .optionallyWith(
        stepAutomationConfiguration.map(value => value.buildAwsValue())
      )(_.stepAutomationConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhuborchestrator.model.GetTemplateStepResponse.ReadOnly =
    zio.aws.migrationhuborchestrator.model.GetTemplateStepResponse
      .wrap(buildAwsValue())
}
object GetTemplateStepResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhuborchestrator.model.GetTemplateStepResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhuborchestrator.model.GetTemplateStepResponse =
      zio.aws.migrationhuborchestrator.model.GetTemplateStepResponse(
        id.map(value => value),
        stepGroupId.map(value => value),
        templateId.map(value => value),
        name.map(value => value),
        description.map(value => value),
        stepActionType.map(value => value),
        creationTime.map(value => value),
        previous.map(value => value),
        next.map(value => value),
        outputs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        stepAutomationConfiguration.map(value => value.asEditable)
      )
    def id: Optional[StepId]
    def stepGroupId: Optional[StepGroupId]
    def templateId: Optional[TemplateId]
    def name: Optional[String]
    def description: Optional[String]
    def stepActionType
        : Optional[zio.aws.migrationhuborchestrator.model.StepActionType]
    def creationTime: Optional[String]
    def previous: Optional[List[StringListMember]]
    def next: Optional[List[StringListMember]]
    def outputs: Optional[
      List[zio.aws.migrationhuborchestrator.model.StepOutput.ReadOnly]
    ]
    def stepAutomationConfiguration: Optional[
      zio.aws.migrationhuborchestrator.model.StepAutomationConfiguration.ReadOnly
    ]
    def getId: ZIO[Any, AwsError, StepId] = AwsError.unwrapOptionField("id", id)
    def getStepGroupId: ZIO[Any, AwsError, StepGroupId] =
      AwsError.unwrapOptionField("stepGroupId", stepGroupId)
    def getTemplateId: ZIO[Any, AwsError, TemplateId] =
      AwsError.unwrapOptionField("templateId", templateId)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getStepActionType: ZIO[
      Any,
      AwsError,
      zio.aws.migrationhuborchestrator.model.StepActionType
    ] = AwsError.unwrapOptionField("stepActionType", stepActionType)
    def getCreationTime: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getPrevious: ZIO[Any, AwsError, List[StringListMember]] =
      AwsError.unwrapOptionField("previous", previous)
    def getNext: ZIO[Any, AwsError, List[StringListMember]] =
      AwsError.unwrapOptionField("next", next)
    def getOutputs: ZIO[Any, AwsError, List[
      zio.aws.migrationhuborchestrator.model.StepOutput.ReadOnly
    ]] = AwsError.unwrapOptionField("outputs", outputs)
    def getStepAutomationConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.migrationhuborchestrator.model.StepAutomationConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "stepAutomationConfiguration",
      stepAutomationConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.GetTemplateStepResponse
  ) extends zio.aws.migrationhuborchestrator.model.GetTemplateStepResponse.ReadOnly {
    override val id: Optional[StepId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value =>
        zio.aws.migrationhuborchestrator.model.primitives.StepId(value)
      )
    override val stepGroupId: Optional[StepGroupId] = zio.aws.core.internal
      .optionalFromNullable(impl.stepGroupId())
      .map(value =>
        zio.aws.migrationhuborchestrator.model.primitives.StepGroupId(value)
      )
    override val templateId: Optional[TemplateId] = zio.aws.core.internal
      .optionalFromNullable(impl.templateId())
      .map(value =>
        zio.aws.migrationhuborchestrator.model.primitives.TemplateId(value)
      )
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val stepActionType
        : Optional[zio.aws.migrationhuborchestrator.model.StepActionType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stepActionType())
        .map(value =>
          zio.aws.migrationhuborchestrator.model.StepActionType.wrap(value)
        )
    override val creationTime: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => value: String)
    override val previous: Optional[List[StringListMember]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.previous())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.migrationhuborchestrator.model.primitives
              .StringListMember(item)
          }.toList
        )
    override val next: Optional[List[StringListMember]] = zio.aws.core.internal
      .optionalFromNullable(impl.next())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.migrationhuborchestrator.model.primitives
            .StringListMember(item)
        }.toList
      )
    override val outputs: Optional[
      List[zio.aws.migrationhuborchestrator.model.StepOutput.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.outputs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.migrationhuborchestrator.model.StepOutput.wrap(item)
        }.toList
      )
    override val stepAutomationConfiguration: Optional[
      zio.aws.migrationhuborchestrator.model.StepAutomationConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.stepAutomationConfiguration())
      .map(value =>
        zio.aws.migrationhuborchestrator.model.StepAutomationConfiguration
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.GetTemplateStepResponse
  ): zio.aws.migrationhuborchestrator.model.GetTemplateStepResponse.ReadOnly =
    new Wrapper(impl)
}
