package zio.aws.migrationhuborchestrator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.migrationhuborchestrator.model.primitives.MigrationWorkflowId
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteWorkflowResponse(
    id: Optional[MigrationWorkflowId] = Optional.Absent,
    arn: Optional[String] = Optional.Absent,
    status: Optional[
      zio.aws.migrationhuborchestrator.model.MigrationWorkflowStatusEnum
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhuborchestrator.model.DeleteWorkflowResponse = {
    import DeleteWorkflowResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhuborchestrator.model.DeleteWorkflowResponse
      .builder()
      .optionallyWith(
        id.map(value => MigrationWorkflowId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhuborchestrator.model.DeleteWorkflowResponse.ReadOnly =
    zio.aws.migrationhuborchestrator.model.DeleteWorkflowResponse
      .wrap(buildAwsValue())
}
object DeleteWorkflowResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhuborchestrator.model.DeleteWorkflowResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhuborchestrator.model.DeleteWorkflowResponse =
      zio.aws.migrationhuborchestrator.model.DeleteWorkflowResponse(
        id.map(value => value),
        arn.map(value => value),
        status.map(value => value)
      )
    def id: Optional[MigrationWorkflowId]
    def arn: Optional[String]
    def status: Optional[
      zio.aws.migrationhuborchestrator.model.MigrationWorkflowStatusEnum
    ]
    def getId: ZIO[Any, AwsError, MigrationWorkflowId] =
      AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.migrationhuborchestrator.model.MigrationWorkflowStatusEnum
    ] = AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.DeleteWorkflowResponse
  ) extends zio.aws.migrationhuborchestrator.model.DeleteWorkflowResponse.ReadOnly {
    override val id: Optional[MigrationWorkflowId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value =>
        zio.aws.migrationhuborchestrator.model.primitives
          .MigrationWorkflowId(value)
      )
    override val arn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: String)
    override val status: Optional[
      zio.aws.migrationhuborchestrator.model.MigrationWorkflowStatusEnum
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value =>
        zio.aws.migrationhuborchestrator.model.MigrationWorkflowStatusEnum
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.DeleteWorkflowResponse
  ): zio.aws.migrationhuborchestrator.model.DeleteWorkflowResponse.ReadOnly =
    new Wrapper(impl)
}
