package zio.aws.migrationhuborchestrator.model
import scala.jdk.CollectionConverters.*
sealed trait DataType {
  def unwrap
      : software.amazon.awssdk.services.migrationhuborchestrator.model.DataType
}
object DataType {
  def wrap(
      value: software.amazon.awssdk.services.migrationhuborchestrator.model.DataType
  ): zio.aws.migrationhuborchestrator.model.DataType = value match {
    case software.amazon.awssdk.services.migrationhuborchestrator.model.DataType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.migrationhuborchestrator.model.DataType.STRING =>
      val r = STRING
      r
    case software.amazon.awssdk.services.migrationhuborchestrator.model.DataType.INTEGER =>
      val r = INTEGER
      r
    case software.amazon.awssdk.services.migrationhuborchestrator.model.DataType.STRINGLIST =>
      val r = STRINGLIST
      r
    case software.amazon.awssdk.services.migrationhuborchestrator.model.DataType.STRINGMAP =>
      val r = STRINGMAP
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.migrationhuborchestrator.model.DataType {
    override def unwrap
        : software.amazon.awssdk.services.migrationhuborchestrator.model.DataType =
      software.amazon.awssdk.services.migrationhuborchestrator.model.DataType.UNKNOWN_TO_SDK_VERSION
  }
  case object STRING extends zio.aws.migrationhuborchestrator.model.DataType {
    override def unwrap
        : software.amazon.awssdk.services.migrationhuborchestrator.model.DataType =
      software.amazon.awssdk.services.migrationhuborchestrator.model.DataType.STRING
  }
  case object INTEGER extends zio.aws.migrationhuborchestrator.model.DataType {
    override def unwrap
        : software.amazon.awssdk.services.migrationhuborchestrator.model.DataType =
      software.amazon.awssdk.services.migrationhuborchestrator.model.DataType.INTEGER
  }
  case object STRINGLIST
      extends zio.aws.migrationhuborchestrator.model.DataType {
    override def unwrap
        : software.amazon.awssdk.services.migrationhuborchestrator.model.DataType =
      software.amazon.awssdk.services.migrationhuborchestrator.model.DataType.STRINGLIST
  }
  case object STRINGMAP
      extends zio.aws.migrationhuborchestrator.model.DataType {
    override def unwrap
        : software.amazon.awssdk.services.migrationhuborchestrator.model.DataType =
      software.amazon.awssdk.services.migrationhuborchestrator.model.DataType.STRINGMAP
  }
}
