package zio.aws.migrationhuborchestrator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.migrationhuborchestrator.model.primitives.{
  StringListMember,
  MigrationWorkflowName,
  MigrationWorkflowId,
  StepGroupId,
  MigrationWorkflowDescription
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateWorkflowStepRequest(
    name: MigrationWorkflowName,
    stepGroupId: StepGroupId,
    workflowId: MigrationWorkflowId,
    stepActionType: zio.aws.migrationhuborchestrator.model.StepActionType,
    description: Optional[MigrationWorkflowDescription] = Optional.Absent,
    workflowStepAutomationConfiguration: Optional[
      zio.aws.migrationhuborchestrator.model.WorkflowStepAutomationConfiguration
    ] = Optional.Absent,
    stepTarget: Optional[Iterable[StringListMember]] = Optional.Absent,
    outputs: Optional[
      Iterable[zio.aws.migrationhuborchestrator.model.WorkflowStepOutput]
    ] = Optional.Absent,
    previous: Optional[Iterable[StringListMember]] = Optional.Absent,
    next: Optional[Iterable[StringListMember]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhuborchestrator.model.CreateWorkflowStepRequest = {
    import CreateWorkflowStepRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhuborchestrator.model.CreateWorkflowStepRequest
      .builder()
      .name(MigrationWorkflowName.unwrap(name): java.lang.String)
      .stepGroupId(StepGroupId.unwrap(stepGroupId): java.lang.String)
      .workflowId(MigrationWorkflowId.unwrap(workflowId): java.lang.String)
      .stepActionType(stepActionType.unwrap)
      .optionallyWith(
        description.map(value =>
          MigrationWorkflowDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        workflowStepAutomationConfiguration.map(value => value.buildAwsValue())
      )(_.workflowStepAutomationConfiguration)
      .optionallyWith(
        stepTarget.map(value =>
          value.map { item =>
            StringListMember.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.stepTarget)
      .optionallyWith(
        outputs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.outputs)
      .optionallyWith(
        previous.map(value =>
          value.map { item =>
            StringListMember.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.previous)
      .optionallyWith(
        next.map(value =>
          value.map { item =>
            StringListMember.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.next)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhuborchestrator.model.CreateWorkflowStepRequest.ReadOnly =
    zio.aws.migrationhuborchestrator.model.CreateWorkflowStepRequest
      .wrap(buildAwsValue())
}
object CreateWorkflowStepRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhuborchestrator.model.CreateWorkflowStepRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhuborchestrator.model.CreateWorkflowStepRequest =
      zio.aws.migrationhuborchestrator.model.CreateWorkflowStepRequest(
        name,
        stepGroupId,
        workflowId,
        stepActionType,
        description.map(value => value),
        workflowStepAutomationConfiguration.map(value => value.asEditable),
        stepTarget.map(value => value),
        outputs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        previous.map(value => value),
        next.map(value => value)
      )
    def name: MigrationWorkflowName
    def stepGroupId: StepGroupId
    def workflowId: MigrationWorkflowId
    def stepActionType: zio.aws.migrationhuborchestrator.model.StepActionType
    def description: Optional[MigrationWorkflowDescription]
    def workflowStepAutomationConfiguration: Optional[
      zio.aws.migrationhuborchestrator.model.WorkflowStepAutomationConfiguration.ReadOnly
    ]
    def stepTarget: Optional[List[StringListMember]]
    def outputs: Optional[
      List[zio.aws.migrationhuborchestrator.model.WorkflowStepOutput.ReadOnly]
    ]
    def previous: Optional[List[StringListMember]]
    def next: Optional[List[StringListMember]]
    def getName: ZIO[Any, Nothing, MigrationWorkflowName] = ZIO.succeed(name)
    def getStepGroupId: ZIO[Any, Nothing, StepGroupId] =
      ZIO.succeed(stepGroupId)
    def getWorkflowId: ZIO[Any, Nothing, MigrationWorkflowId] =
      ZIO.succeed(workflowId)
    def getStepActionType: ZIO[
      Any,
      Nothing,
      zio.aws.migrationhuborchestrator.model.StepActionType
    ] = ZIO.succeed(stepActionType)
    def getDescription: ZIO[Any, AwsError, MigrationWorkflowDescription] =
      AwsError.unwrapOptionField("description", description)
    def getWorkflowStepAutomationConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.migrationhuborchestrator.model.WorkflowStepAutomationConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "workflowStepAutomationConfiguration",
      workflowStepAutomationConfiguration
    )
    def getStepTarget: ZIO[Any, AwsError, List[StringListMember]] =
      AwsError.unwrapOptionField("stepTarget", stepTarget)
    def getOutputs: ZIO[Any, AwsError, List[
      zio.aws.migrationhuborchestrator.model.WorkflowStepOutput.ReadOnly
    ]] = AwsError.unwrapOptionField("outputs", outputs)
    def getPrevious: ZIO[Any, AwsError, List[StringListMember]] =
      AwsError.unwrapOptionField("previous", previous)
    def getNext: ZIO[Any, AwsError, List[StringListMember]] =
      AwsError.unwrapOptionField("next", next)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.CreateWorkflowStepRequest
  ) extends zio.aws.migrationhuborchestrator.model.CreateWorkflowStepRequest.ReadOnly {
    override val name: MigrationWorkflowName =
      zio.aws.migrationhuborchestrator.model.primitives
        .MigrationWorkflowName(impl.name())
    override val stepGroupId: StepGroupId =
      zio.aws.migrationhuborchestrator.model.primitives
        .StepGroupId(impl.stepGroupId())
    override val workflowId: MigrationWorkflowId =
      zio.aws.migrationhuborchestrator.model.primitives
        .MigrationWorkflowId(impl.workflowId())
    override val stepActionType
        : zio.aws.migrationhuborchestrator.model.StepActionType =
      zio.aws.migrationhuborchestrator.model.StepActionType
        .wrap(impl.stepActionType())
    override val description: Optional[MigrationWorkflowDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.migrationhuborchestrator.model.primitives
            .MigrationWorkflowDescription(value)
        )
    override val workflowStepAutomationConfiguration: Optional[
      zio.aws.migrationhuborchestrator.model.WorkflowStepAutomationConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.workflowStepAutomationConfiguration())
      .map(value =>
        zio.aws.migrationhuborchestrator.model.WorkflowStepAutomationConfiguration
          .wrap(value)
      )
    override val stepTarget: Optional[List[StringListMember]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stepTarget())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.migrationhuborchestrator.model.primitives
              .StringListMember(item)
          }.toList
        )
    override val outputs: Optional[
      List[zio.aws.migrationhuborchestrator.model.WorkflowStepOutput.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.outputs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.migrationhuborchestrator.model.WorkflowStepOutput.wrap(item)
        }.toList
      )
    override val previous: Optional[List[StringListMember]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.previous())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.migrationhuborchestrator.model.primitives
              .StringListMember(item)
          }.toList
        )
    override val next: Optional[List[StringListMember]] = zio.aws.core.internal
      .optionalFromNullable(impl.next())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.migrationhuborchestrator.model.primitives
            .StringListMember(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.CreateWorkflowStepRequest
  ): zio.aws.migrationhuborchestrator.model.CreateWorkflowStepRequest.ReadOnly =
    new Wrapper(impl)
}
