package zio.aws.migrationhub.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.migrationhub.model.primitives.{
  MigrationTaskName,
  ProgressUpdateStream
}
import scala.jdk.CollectionConverters._
final case class DescribeMigrationTaskRequest(
    progressUpdateStream: ProgressUpdateStream,
    migrationTaskName: MigrationTaskName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhub.model.DescribeMigrationTaskRequest = {
    import DescribeMigrationTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhub.model.DescribeMigrationTaskRequest
      .builder()
      .progressUpdateStream(
        ProgressUpdateStream.unwrap(progressUpdateStream): java.lang.String
      )
      .migrationTaskName(
        MigrationTaskName.unwrap(migrationTaskName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhub.model.DescribeMigrationTaskRequest.ReadOnly =
    zio.aws.migrationhub.model.DescribeMigrationTaskRequest
      .wrap(buildAwsValue())
}
object DescribeMigrationTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhub.model.DescribeMigrationTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.migrationhub.model.DescribeMigrationTaskRequest =
      zio.aws.migrationhub.model
        .DescribeMigrationTaskRequest(progressUpdateStream, migrationTaskName)
    def progressUpdateStream: ProgressUpdateStream
    def migrationTaskName: MigrationTaskName
    def getProgressUpdateStream: ZIO[Any, Nothing, ProgressUpdateStream] =
      ZIO.succeed(progressUpdateStream)
    def getMigrationTaskName: ZIO[Any, Nothing, MigrationTaskName] =
      ZIO.succeed(migrationTaskName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhub.model.DescribeMigrationTaskRequest
  ) extends zio.aws.migrationhub.model.DescribeMigrationTaskRequest.ReadOnly {
    override val progressUpdateStream: ProgressUpdateStream =
      zio.aws.migrationhub.model.primitives
        .ProgressUpdateStream(impl.progressUpdateStream())
    override val migrationTaskName: MigrationTaskName =
      zio.aws.migrationhub.model.primitives
        .MigrationTaskName(impl.migrationTaskName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhub.model.DescribeMigrationTaskRequest
  ): zio.aws.migrationhub.model.DescribeMigrationTaskRequest.ReadOnly =
    new Wrapper(impl)
}
