package zio.aws.migrationhub
import zio.aws.migrationhub.model.ImportMigrationTaskResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.migrationhub.model.{
  DisassociateDiscoveredResourceRequest,
  ImportMigrationTaskRequest,
  ListCreatedArtifactsResponse,
  ListMigrationTasksResponse,
  PutResourceAttributesRequest,
  DescribeMigrationTaskRequest,
  NotifyMigrationTaskStateRequest,
  ListMigrationTasksRequest,
  DescribeMigrationTaskResponse,
  AssociateDiscoveredResourceRequest,
  DisassociateCreatedArtifactRequest,
  ProgressUpdateStreamSummary,
  ListDiscoveredResourcesResponse,
  ListApplicationStatesResponse,
  NotifyApplicationStateRequest,
  CreatedArtifact,
  DeleteProgressUpdateStreamRequest,
  NotifyApplicationStateResponse,
  ListApplicationStatesRequest,
  DescribeApplicationStateRequest,
  ListDiscoveredResourcesRequest,
  DisassociateDiscoveredResourceResponse,
  ListProgressUpdateStreamsResponse,
  DescribeApplicationStateResponse,
  DeleteProgressUpdateStreamResponse,
  AssociateCreatedArtifactResponse,
  ImportMigrationTaskResponse,
  PutResourceAttributesResponse,
  CreateProgressUpdateStreamRequest,
  NotifyMigrationTaskStateResponse,
  ListCreatedArtifactsRequest,
  CreateProgressUpdateStreamResponse,
  AssociateDiscoveredResourceResponse,
  AssociateCreatedArtifactRequest,
  MigrationTaskSummary,
  ListProgressUpdateStreamsRequest,
  ApplicationState,
  DiscoveredResource,
  DisassociateCreatedArtifactResponse
}
import zio.aws.core.{AwsServiceBase, AwsError}
import software.amazon.awssdk.services.migrationhub.{
  MigrationHubAsyncClientBuilder,
  MigrationHubAsyncClient
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import zio.stream.ZStream
import scala.jdk.CollectionConverters._
trait MigrationHub extends AspectSupport[MigrationHub] {
  val api: MigrationHubAsyncClient
  def associateDiscoveredResource(
      request: zio.aws.migrationhub.model.AssociateDiscoveredResourceRequest
  ): IO[
    AwsError,
    zio.aws.migrationhub.model.AssociateDiscoveredResourceResponse.ReadOnly
  ]
  def notifyMigrationTaskState(
      request: zio.aws.migrationhub.model.NotifyMigrationTaskStateRequest
  ): IO[
    AwsError,
    zio.aws.migrationhub.model.NotifyMigrationTaskStateResponse.ReadOnly
  ]
  def disassociateDiscoveredResource(
      request: zio.aws.migrationhub.model.DisassociateDiscoveredResourceRequest
  ): IO[
    AwsError,
    zio.aws.migrationhub.model.DisassociateDiscoveredResourceResponse.ReadOnly
  ]
  def listMigrationTasks(
      request: zio.aws.migrationhub.model.ListMigrationTasksRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.migrationhub.model.MigrationTaskSummary.ReadOnly
  ]
  def listMigrationTasksPaginated(
      request: zio.aws.migrationhub.model.ListMigrationTasksRequest
  ): IO[
    AwsError,
    zio.aws.migrationhub.model.ListMigrationTasksResponse.ReadOnly
  ]
  def associateCreatedArtifact(
      request: zio.aws.migrationhub.model.AssociateCreatedArtifactRequest
  ): IO[
    AwsError,
    zio.aws.migrationhub.model.AssociateCreatedArtifactResponse.ReadOnly
  ]
  def createProgressUpdateStream(
      request: zio.aws.migrationhub.model.CreateProgressUpdateStreamRequest
  ): IO[
    AwsError,
    zio.aws.migrationhub.model.CreateProgressUpdateStreamResponse.ReadOnly
  ]
  def putResourceAttributes(
      request: zio.aws.migrationhub.model.PutResourceAttributesRequest
  ): IO[
    AwsError,
    zio.aws.migrationhub.model.PutResourceAttributesResponse.ReadOnly
  ]
  def listApplicationStates(
      request: zio.aws.migrationhub.model.ListApplicationStatesRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.migrationhub.model.ApplicationState.ReadOnly
  ]
  def listApplicationStatesPaginated(
      request: zio.aws.migrationhub.model.ListApplicationStatesRequest
  ): IO[
    AwsError,
    zio.aws.migrationhub.model.ListApplicationStatesResponse.ReadOnly
  ]
  def deleteProgressUpdateStream(
      request: zio.aws.migrationhub.model.DeleteProgressUpdateStreamRequest
  ): IO[
    AwsError,
    zio.aws.migrationhub.model.DeleteProgressUpdateStreamResponse.ReadOnly
  ]
  def notifyApplicationState(
      request: zio.aws.migrationhub.model.NotifyApplicationStateRequest
  ): IO[
    AwsError,
    zio.aws.migrationhub.model.NotifyApplicationStateResponse.ReadOnly
  ]
  def listCreatedArtifacts(
      request: zio.aws.migrationhub.model.ListCreatedArtifactsRequest
  ): ZStream[Any, AwsError, zio.aws.migrationhub.model.CreatedArtifact.ReadOnly]
  def listCreatedArtifactsPaginated(
      request: zio.aws.migrationhub.model.ListCreatedArtifactsRequest
  ): IO[
    AwsError,
    zio.aws.migrationhub.model.ListCreatedArtifactsResponse.ReadOnly
  ]
  def disassociateCreatedArtifact(
      request: zio.aws.migrationhub.model.DisassociateCreatedArtifactRequest
  ): IO[
    AwsError,
    zio.aws.migrationhub.model.DisassociateCreatedArtifactResponse.ReadOnly
  ]
  def importMigrationTask(
      request: zio.aws.migrationhub.model.ImportMigrationTaskRequest
  ): IO[AwsError, ReadOnly]
  def listProgressUpdateStreams(
      request: zio.aws.migrationhub.model.ListProgressUpdateStreamsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.migrationhub.model.ProgressUpdateStreamSummary.ReadOnly
  ]
  def listProgressUpdateStreamsPaginated(
      request: zio.aws.migrationhub.model.ListProgressUpdateStreamsRequest
  ): IO[
    AwsError,
    zio.aws.migrationhub.model.ListProgressUpdateStreamsResponse.ReadOnly
  ]
  def describeMigrationTask(
      request: zio.aws.migrationhub.model.DescribeMigrationTaskRequest
  ): IO[
    AwsError,
    zio.aws.migrationhub.model.DescribeMigrationTaskResponse.ReadOnly
  ]
  def listDiscoveredResources(
      request: zio.aws.migrationhub.model.ListDiscoveredResourcesRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.migrationhub.model.DiscoveredResource.ReadOnly
  ]
  def listDiscoveredResourcesPaginated(
      request: zio.aws.migrationhub.model.ListDiscoveredResourcesRequest
  ): IO[
    AwsError,
    zio.aws.migrationhub.model.ListDiscoveredResourcesResponse.ReadOnly
  ]
  def describeApplicationState(
      request: zio.aws.migrationhub.model.DescribeApplicationStateRequest
  ): IO[
    AwsError,
    zio.aws.migrationhub.model.DescribeApplicationStateResponse.ReadOnly
  ]
}
object MigrationHub {
  val live: ZLayer[AwsConfig, java.lang.Throwable, MigrationHub] = customized(
    identity
  )
  def customized(
      customization: MigrationHubAsyncClientBuilder => MigrationHubAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, MigrationHub] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: MigrationHubAsyncClientBuilder => MigrationHubAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, MigrationHub] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = MigrationHubAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[MigrationHubAsyncClient, MigrationHubAsyncClientBuilder](
        builder
      );
    b1 <- awsConfig.configureHttpClient[
      MigrationHubAsyncClient,
      MigrationHubAsyncClientBuilder
    ](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  )
    yield new MigrationHubImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class MigrationHubImpl[R](
      override val api: MigrationHubAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends MigrationHub
      with AwsServiceBase[R] {
    override val serviceName: String = "MigrationHub"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): MigrationHubImpl[R1] = new MigrationHubImpl(api, newAspect, r)
    def associateDiscoveredResource(
        request: zio.aws.migrationhub.model.AssociateDiscoveredResourceRequest
    ): IO[
      AwsError,
      zio.aws.migrationhub.model.AssociateDiscoveredResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      AssociateDiscoveredResourceRequest,
      AssociateDiscoveredResourceResponse
    ]("associateDiscoveredResource", api.associateDiscoveredResource)(
      request.buildAwsValue()
    ).map(zio.aws.migrationhub.model.AssociateDiscoveredResourceResponse.wrap)
      .provideEnvironment(r)
    def notifyMigrationTaskState(
        request: zio.aws.migrationhub.model.NotifyMigrationTaskStateRequest
    ): IO[
      AwsError,
      zio.aws.migrationhub.model.NotifyMigrationTaskStateResponse.ReadOnly
    ] = asyncRequestResponse[
      NotifyMigrationTaskStateRequest,
      NotifyMigrationTaskStateResponse
    ]("notifyMigrationTaskState", api.notifyMigrationTaskState)(
      request.buildAwsValue()
    ).map(zio.aws.migrationhub.model.NotifyMigrationTaskStateResponse.wrap)
      .provideEnvironment(r)
    def disassociateDiscoveredResource(
        request: zio.aws.migrationhub.model.DisassociateDiscoveredResourceRequest
    ): IO[
      AwsError,
      zio.aws.migrationhub.model.DisassociateDiscoveredResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      DisassociateDiscoveredResourceRequest,
      DisassociateDiscoveredResourceResponse
    ]("disassociateDiscoveredResource", api.disassociateDiscoveredResource)(
      request.buildAwsValue()
    ).map(
      zio.aws.migrationhub.model.DisassociateDiscoveredResourceResponse.wrap
    ).provideEnvironment(r)
    def listMigrationTasks(
        request: zio.aws.migrationhub.model.ListMigrationTasksRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.migrationhub.model.MigrationTaskSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListMigrationTasksRequest,
      ListMigrationTasksResponse,
      MigrationTaskSummary
    ](
      "listMigrationTasks",
      api.listMigrationTasks,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.migrationTaskSummaryList().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.migrationhub.model.MigrationTaskSummary.wrap(item))
      .provideEnvironment(r)
    def listMigrationTasksPaginated(
        request: zio.aws.migrationhub.model.ListMigrationTasksRequest
    ): IO[
      AwsError,
      zio.aws.migrationhub.model.ListMigrationTasksResponse.ReadOnly
    ] = asyncRequestResponse[
      ListMigrationTasksRequest,
      ListMigrationTasksResponse
    ]("listMigrationTasks", api.listMigrationTasks)(request.buildAwsValue())
      .map(zio.aws.migrationhub.model.ListMigrationTasksResponse.wrap)
      .provideEnvironment(r)
    def associateCreatedArtifact(
        request: zio.aws.migrationhub.model.AssociateCreatedArtifactRequest
    ): IO[
      AwsError,
      zio.aws.migrationhub.model.AssociateCreatedArtifactResponse.ReadOnly
    ] = asyncRequestResponse[
      AssociateCreatedArtifactRequest,
      AssociateCreatedArtifactResponse
    ]("associateCreatedArtifact", api.associateCreatedArtifact)(
      request.buildAwsValue()
    ).map(zio.aws.migrationhub.model.AssociateCreatedArtifactResponse.wrap)
      .provideEnvironment(r)
    def createProgressUpdateStream(
        request: zio.aws.migrationhub.model.CreateProgressUpdateStreamRequest
    ): IO[
      AwsError,
      zio.aws.migrationhub.model.CreateProgressUpdateStreamResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateProgressUpdateStreamRequest,
      CreateProgressUpdateStreamResponse
    ]("createProgressUpdateStream", api.createProgressUpdateStream)(
      request.buildAwsValue()
    ).map(zio.aws.migrationhub.model.CreateProgressUpdateStreamResponse.wrap)
      .provideEnvironment(r)
    def putResourceAttributes(
        request: zio.aws.migrationhub.model.PutResourceAttributesRequest
    ): IO[
      AwsError,
      zio.aws.migrationhub.model.PutResourceAttributesResponse.ReadOnly
    ] = asyncRequestResponse[
      PutResourceAttributesRequest,
      PutResourceAttributesResponse
    ]("putResourceAttributes", api.putResourceAttributes)(
      request.buildAwsValue()
    ).map(zio.aws.migrationhub.model.PutResourceAttributesResponse.wrap)
      .provideEnvironment(r)
    def listApplicationStates(
        request: zio.aws.migrationhub.model.ListApplicationStatesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.migrationhub.model.ApplicationState.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListApplicationStatesRequest,
      ListApplicationStatesResponse,
      ApplicationState
    ](
      "listApplicationStates",
      api.listApplicationStates,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.applicationStateList().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.migrationhub.model.ApplicationState.wrap(item))
      .provideEnvironment(r)
    def listApplicationStatesPaginated(
        request: zio.aws.migrationhub.model.ListApplicationStatesRequest
    ): IO[
      AwsError,
      zio.aws.migrationhub.model.ListApplicationStatesResponse.ReadOnly
    ] = asyncRequestResponse[
      ListApplicationStatesRequest,
      ListApplicationStatesResponse
    ]("listApplicationStates", api.listApplicationStates)(
      request.buildAwsValue()
    ).map(zio.aws.migrationhub.model.ListApplicationStatesResponse.wrap)
      .provideEnvironment(r)
    def deleteProgressUpdateStream(
        request: zio.aws.migrationhub.model.DeleteProgressUpdateStreamRequest
    ): IO[
      AwsError,
      zio.aws.migrationhub.model.DeleteProgressUpdateStreamResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteProgressUpdateStreamRequest,
      DeleteProgressUpdateStreamResponse
    ]("deleteProgressUpdateStream", api.deleteProgressUpdateStream)(
      request.buildAwsValue()
    ).map(zio.aws.migrationhub.model.DeleteProgressUpdateStreamResponse.wrap)
      .provideEnvironment(r)
    def notifyApplicationState(
        request: zio.aws.migrationhub.model.NotifyApplicationStateRequest
    ): IO[
      AwsError,
      zio.aws.migrationhub.model.NotifyApplicationStateResponse.ReadOnly
    ] = asyncRequestResponse[
      NotifyApplicationStateRequest,
      NotifyApplicationStateResponse
    ]("notifyApplicationState", api.notifyApplicationState)(
      request.buildAwsValue()
    ).map(zio.aws.migrationhub.model.NotifyApplicationStateResponse.wrap)
      .provideEnvironment(r)
    def listCreatedArtifacts(
        request: zio.aws.migrationhub.model.ListCreatedArtifactsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.migrationhub.model.CreatedArtifact.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListCreatedArtifactsRequest,
      ListCreatedArtifactsResponse,
      CreatedArtifact
    ](
      "listCreatedArtifacts",
      api.listCreatedArtifacts,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.createdArtifactList().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.migrationhub.model.CreatedArtifact.wrap(item))
      .provideEnvironment(r)
    def listCreatedArtifactsPaginated(
        request: zio.aws.migrationhub.model.ListCreatedArtifactsRequest
    ): IO[
      AwsError,
      zio.aws.migrationhub.model.ListCreatedArtifactsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListCreatedArtifactsRequest,
      ListCreatedArtifactsResponse
    ]("listCreatedArtifacts", api.listCreatedArtifacts)(request.buildAwsValue())
      .map(zio.aws.migrationhub.model.ListCreatedArtifactsResponse.wrap)
      .provideEnvironment(r)
    def disassociateCreatedArtifact(
        request: zio.aws.migrationhub.model.DisassociateCreatedArtifactRequest
    ): IO[
      AwsError,
      zio.aws.migrationhub.model.DisassociateCreatedArtifactResponse.ReadOnly
    ] = asyncRequestResponse[
      DisassociateCreatedArtifactRequest,
      DisassociateCreatedArtifactResponse
    ]("disassociateCreatedArtifact", api.disassociateCreatedArtifact)(
      request.buildAwsValue()
    ).map(zio.aws.migrationhub.model.DisassociateCreatedArtifactResponse.wrap)
      .provideEnvironment(r)
    def importMigrationTask(
        request: zio.aws.migrationhub.model.ImportMigrationTaskRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      ImportMigrationTaskRequest,
      ImportMigrationTaskResponse
    ]("importMigrationTask", api.importMigrationTask)(request.buildAwsValue())
      .map(zio.aws.migrationhub.model.ImportMigrationTaskResponse.wrap)
      .provideEnvironment(r)
    def listProgressUpdateStreams(
        request: zio.aws.migrationhub.model.ListProgressUpdateStreamsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.migrationhub.model.ProgressUpdateStreamSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListProgressUpdateStreamsRequest,
      ListProgressUpdateStreamsResponse,
      ProgressUpdateStreamSummary
    ](
      "listProgressUpdateStreams",
      api.listProgressUpdateStreams,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.progressUpdateStreamSummaryList().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.migrationhub.model.ProgressUpdateStreamSummary.wrap(item)
      )
      .provideEnvironment(r)
    def listProgressUpdateStreamsPaginated(
        request: zio.aws.migrationhub.model.ListProgressUpdateStreamsRequest
    ): IO[
      AwsError,
      zio.aws.migrationhub.model.ListProgressUpdateStreamsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListProgressUpdateStreamsRequest,
      ListProgressUpdateStreamsResponse
    ]("listProgressUpdateStreams", api.listProgressUpdateStreams)(
      request.buildAwsValue()
    ).map(zio.aws.migrationhub.model.ListProgressUpdateStreamsResponse.wrap)
      .provideEnvironment(r)
    def describeMigrationTask(
        request: zio.aws.migrationhub.model.DescribeMigrationTaskRequest
    ): IO[
      AwsError,
      zio.aws.migrationhub.model.DescribeMigrationTaskResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeMigrationTaskRequest,
      DescribeMigrationTaskResponse
    ]("describeMigrationTask", api.describeMigrationTask)(
      request.buildAwsValue()
    ).map(zio.aws.migrationhub.model.DescribeMigrationTaskResponse.wrap)
      .provideEnvironment(r)
    def listDiscoveredResources(
        request: zio.aws.migrationhub.model.ListDiscoveredResourcesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.migrationhub.model.DiscoveredResource.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListDiscoveredResourcesRequest,
      ListDiscoveredResourcesResponse,
      DiscoveredResource
    ](
      "listDiscoveredResources",
      api.listDiscoveredResources,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.discoveredResourceList().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.migrationhub.model.DiscoveredResource.wrap(item))
      .provideEnvironment(r)
    def listDiscoveredResourcesPaginated(
        request: zio.aws.migrationhub.model.ListDiscoveredResourcesRequest
    ): IO[
      AwsError,
      zio.aws.migrationhub.model.ListDiscoveredResourcesResponse.ReadOnly
    ] = asyncRequestResponse[
      ListDiscoveredResourcesRequest,
      ListDiscoveredResourcesResponse
    ]("listDiscoveredResources", api.listDiscoveredResources)(
      request.buildAwsValue()
    ).map(zio.aws.migrationhub.model.ListDiscoveredResourcesResponse.wrap)
      .provideEnvironment(r)
    def describeApplicationState(
        request: zio.aws.migrationhub.model.DescribeApplicationStateRequest
    ): IO[
      AwsError,
      zio.aws.migrationhub.model.DescribeApplicationStateResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeApplicationStateRequest,
      DescribeApplicationStateResponse
    ]("describeApplicationState", api.describeApplicationState)(
      request.buildAwsValue()
    ).map(zio.aws.migrationhub.model.DescribeApplicationStateResponse.wrap)
      .provideEnvironment(r)
  }
  def associateDiscoveredResource(
      request: zio.aws.migrationhub.model.AssociateDiscoveredResourceRequest
  ): ZIO[
    zio.aws.migrationhub.MigrationHub,
    AwsError,
    zio.aws.migrationhub.model.AssociateDiscoveredResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateDiscoveredResource(request))
  def notifyMigrationTaskState(
      request: zio.aws.migrationhub.model.NotifyMigrationTaskStateRequest
  ): ZIO[
    zio.aws.migrationhub.MigrationHub,
    AwsError,
    zio.aws.migrationhub.model.NotifyMigrationTaskStateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.notifyMigrationTaskState(request))
  def disassociateDiscoveredResource(
      request: zio.aws.migrationhub.model.DisassociateDiscoveredResourceRequest
  ): ZIO[
    zio.aws.migrationhub.MigrationHub,
    AwsError,
    zio.aws.migrationhub.model.DisassociateDiscoveredResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateDiscoveredResource(request))
  def listMigrationTasks(
      request: zio.aws.migrationhub.model.ListMigrationTasksRequest
  ): ZStream[
    zio.aws.migrationhub.MigrationHub,
    AwsError,
    zio.aws.migrationhub.model.MigrationTaskSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listMigrationTasks(request))
  def listMigrationTasksPaginated(
      request: zio.aws.migrationhub.model.ListMigrationTasksRequest
  ): ZIO[
    zio.aws.migrationhub.MigrationHub,
    AwsError,
    zio.aws.migrationhub.model.ListMigrationTasksResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listMigrationTasksPaginated(request))
  def associateCreatedArtifact(
      request: zio.aws.migrationhub.model.AssociateCreatedArtifactRequest
  ): ZIO[
    zio.aws.migrationhub.MigrationHub,
    AwsError,
    zio.aws.migrationhub.model.AssociateCreatedArtifactResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateCreatedArtifact(request))
  def createProgressUpdateStream(
      request: zio.aws.migrationhub.model.CreateProgressUpdateStreamRequest
  ): ZIO[
    zio.aws.migrationhub.MigrationHub,
    AwsError,
    zio.aws.migrationhub.model.CreateProgressUpdateStreamResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createProgressUpdateStream(request))
  def putResourceAttributes(
      request: zio.aws.migrationhub.model.PutResourceAttributesRequest
  ): ZIO[
    zio.aws.migrationhub.MigrationHub,
    AwsError,
    zio.aws.migrationhub.model.PutResourceAttributesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putResourceAttributes(request))
  def listApplicationStates(
      request: zio.aws.migrationhub.model.ListApplicationStatesRequest
  ): ZStream[
    zio.aws.migrationhub.MigrationHub,
    AwsError,
    zio.aws.migrationhub.model.ApplicationState.ReadOnly
  ] = ZStream.serviceWithStream(_.listApplicationStates(request))
  def listApplicationStatesPaginated(
      request: zio.aws.migrationhub.model.ListApplicationStatesRequest
  ): ZIO[
    zio.aws.migrationhub.MigrationHub,
    AwsError,
    zio.aws.migrationhub.model.ListApplicationStatesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listApplicationStatesPaginated(request))
  def deleteProgressUpdateStream(
      request: zio.aws.migrationhub.model.DeleteProgressUpdateStreamRequest
  ): ZIO[
    zio.aws.migrationhub.MigrationHub,
    AwsError,
    zio.aws.migrationhub.model.DeleteProgressUpdateStreamResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteProgressUpdateStream(request))
  def notifyApplicationState(
      request: zio.aws.migrationhub.model.NotifyApplicationStateRequest
  ): ZIO[
    zio.aws.migrationhub.MigrationHub,
    AwsError,
    zio.aws.migrationhub.model.NotifyApplicationStateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.notifyApplicationState(request))
  def listCreatedArtifacts(
      request: zio.aws.migrationhub.model.ListCreatedArtifactsRequest
  ): ZStream[
    zio.aws.migrationhub.MigrationHub,
    AwsError,
    zio.aws.migrationhub.model.CreatedArtifact.ReadOnly
  ] = ZStream.serviceWithStream(_.listCreatedArtifacts(request))
  def listCreatedArtifactsPaginated(
      request: zio.aws.migrationhub.model.ListCreatedArtifactsRequest
  ): ZIO[
    zio.aws.migrationhub.MigrationHub,
    AwsError,
    zio.aws.migrationhub.model.ListCreatedArtifactsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listCreatedArtifactsPaginated(request))
  def disassociateCreatedArtifact(
      request: zio.aws.migrationhub.model.DisassociateCreatedArtifactRequest
  ): ZIO[
    zio.aws.migrationhub.MigrationHub,
    AwsError,
    zio.aws.migrationhub.model.DisassociateCreatedArtifactResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateCreatedArtifact(request))
  def importMigrationTask(
      request: zio.aws.migrationhub.model.ImportMigrationTaskRequest
  ): ZIO[zio.aws.migrationhub.MigrationHub, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.importMigrationTask(request))
  def listProgressUpdateStreams(
      request: zio.aws.migrationhub.model.ListProgressUpdateStreamsRequest
  ): ZStream[
    zio.aws.migrationhub.MigrationHub,
    AwsError,
    zio.aws.migrationhub.model.ProgressUpdateStreamSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listProgressUpdateStreams(request))
  def listProgressUpdateStreamsPaginated(
      request: zio.aws.migrationhub.model.ListProgressUpdateStreamsRequest
  ): ZIO[
    zio.aws.migrationhub.MigrationHub,
    AwsError,
    zio.aws.migrationhub.model.ListProgressUpdateStreamsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listProgressUpdateStreamsPaginated(request))
  def describeMigrationTask(
      request: zio.aws.migrationhub.model.DescribeMigrationTaskRequest
  ): ZIO[
    zio.aws.migrationhub.MigrationHub,
    AwsError,
    zio.aws.migrationhub.model.DescribeMigrationTaskResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeMigrationTask(request))
  def listDiscoveredResources(
      request: zio.aws.migrationhub.model.ListDiscoveredResourcesRequest
  ): ZStream[
    zio.aws.migrationhub.MigrationHub,
    AwsError,
    zio.aws.migrationhub.model.DiscoveredResource.ReadOnly
  ] = ZStream.serviceWithStream(_.listDiscoveredResources(request))
  def listDiscoveredResourcesPaginated(
      request: zio.aws.migrationhub.model.ListDiscoveredResourcesRequest
  ): ZIO[
    zio.aws.migrationhub.MigrationHub,
    AwsError,
    zio.aws.migrationhub.model.ListDiscoveredResourcesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDiscoveredResourcesPaginated(request))
  def describeApplicationState(
      request: zio.aws.migrationhub.model.DescribeApplicationStateRequest
  ): ZIO[
    zio.aws.migrationhub.MigrationHub,
    AwsError,
    zio.aws.migrationhub.model.DescribeApplicationStateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeApplicationState(request))
}
