package zio.aws.migrationhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.migrationhub.model.primitives.{
  DryRun,
  MigrationTaskName,
  ProgressUpdateStream
}
import scala.jdk.CollectionConverters._
final case class AssociateDiscoveredResourceRequest(
    progressUpdateStream: ProgressUpdateStream,
    migrationTaskName: MigrationTaskName,
    discoveredResource: zio.aws.migrationhub.model.DiscoveredResource,
    dryRun: Optional[DryRun] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhub.model.AssociateDiscoveredResourceRequest = {
    import AssociateDiscoveredResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhub.model.AssociateDiscoveredResourceRequest
      .builder()
      .progressUpdateStream(
        ProgressUpdateStream.unwrap(progressUpdateStream): java.lang.String
      )
      .migrationTaskName(
        MigrationTaskName.unwrap(migrationTaskName): java.lang.String
      )
      .discoveredResource(discoveredResource.buildAwsValue())
      .optionallyWith(
        dryRun.map(value => DryRun.unwrap(value): java.lang.Boolean)
      )(_.dryRun)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhub.model.AssociateDiscoveredResourceRequest.ReadOnly =
    zio.aws.migrationhub.model.AssociateDiscoveredResourceRequest
      .wrap(buildAwsValue())
}
object AssociateDiscoveredResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhub.model.AssociateDiscoveredResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhub.model.AssociateDiscoveredResourceRequest =
      zio.aws.migrationhub.model.AssociateDiscoveredResourceRequest(
        progressUpdateStream,
        migrationTaskName,
        discoveredResource.asEditable,
        dryRun.map(value => value)
      )
    def progressUpdateStream: ProgressUpdateStream
    def migrationTaskName: MigrationTaskName
    def discoveredResource
        : zio.aws.migrationhub.model.DiscoveredResource.ReadOnly
    def dryRun: Optional[DryRun]
    def getProgressUpdateStream: ZIO[Any, Nothing, ProgressUpdateStream] =
      ZIO.succeed(progressUpdateStream)
    def getMigrationTaskName: ZIO[Any, Nothing, MigrationTaskName] =
      ZIO.succeed(migrationTaskName)
    def getDiscoveredResource: ZIO[
      Any,
      Nothing,
      zio.aws.migrationhub.model.DiscoveredResource.ReadOnly
    ] = ZIO.succeed(discoveredResource)
    def getDryRun: ZIO[Any, AwsError, DryRun] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhub.model.AssociateDiscoveredResourceRequest
  ) extends zio.aws.migrationhub.model.AssociateDiscoveredResourceRequest.ReadOnly {
    override val progressUpdateStream: ProgressUpdateStream =
      zio.aws.migrationhub.model.primitives
        .ProgressUpdateStream(impl.progressUpdateStream())
    override val migrationTaskName: MigrationTaskName =
      zio.aws.migrationhub.model.primitives
        .MigrationTaskName(impl.migrationTaskName())
    override val discoveredResource
        : zio.aws.migrationhub.model.DiscoveredResource.ReadOnly =
      zio.aws.migrationhub.model.DiscoveredResource
        .wrap(impl.discoveredResource())
    override val dryRun: Optional[DryRun] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => zio.aws.migrationhub.model.primitives.DryRun(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhub.model.AssociateDiscoveredResourceRequest
  ): zio.aws.migrationhub.model.AssociateDiscoveredResourceRequest.ReadOnly =
    new Wrapper(impl)
}
