package zio.aws.migrationhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.migrationhub.model.primitives.ProgressUpdateStream
import scala.jdk.CollectionConverters._
final case class ProgressUpdateStreamSummary(
    progressUpdateStreamName: Optional[ProgressUpdateStream] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhub.model.ProgressUpdateStreamSummary = {
    import ProgressUpdateStreamSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhub.model.ProgressUpdateStreamSummary
      .builder()
      .optionallyWith(
        progressUpdateStreamName.map(value =>
          ProgressUpdateStream.unwrap(value): java.lang.String
        )
      )(_.progressUpdateStreamName)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhub.model.ProgressUpdateStreamSummary.ReadOnly =
    zio.aws.migrationhub.model.ProgressUpdateStreamSummary.wrap(buildAwsValue())
}
object ProgressUpdateStreamSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhub.model.ProgressUpdateStreamSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.migrationhub.model.ProgressUpdateStreamSummary =
      zio.aws.migrationhub.model.ProgressUpdateStreamSummary(
        progressUpdateStreamName.map(value => value)
      )
    def progressUpdateStreamName: Optional[ProgressUpdateStream]
    def getProgressUpdateStreamName: ZIO[Any, AwsError, ProgressUpdateStream] =
      AwsError.unwrapOptionField(
        "progressUpdateStreamName",
        progressUpdateStreamName
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhub.model.ProgressUpdateStreamSummary
  ) extends zio.aws.migrationhub.model.ProgressUpdateStreamSummary.ReadOnly {
    override val progressUpdateStreamName: Optional[ProgressUpdateStream] =
      zio.aws.core.internal
        .optionalFromNullable(impl.progressUpdateStreamName())
        .map(value =>
          zio.aws.migrationhub.model.primitives.ProgressUpdateStream(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhub.model.ProgressUpdateStreamSummary
  ): zio.aws.migrationhub.model.ProgressUpdateStreamSummary.ReadOnly =
    new Wrapper(impl)
}
