package zio.aws.migrationhub.model
import zio.aws.migrationhub.model.primitives.{ResourceName, MaxResults, Token}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListMigrationTasksRequest(
    nextToken: Optional[Token] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    resourceName: Optional[ResourceName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhub.model.ListMigrationTasksRequest = {
    import ListMigrationTasksRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhub.model.ListMigrationTasksRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        resourceName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.resourceName)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhub.model.ListMigrationTasksRequest.ReadOnly =
    zio.aws.migrationhub.model.ListMigrationTasksRequest.wrap(buildAwsValue())
}
object ListMigrationTasksRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhub.model.ListMigrationTasksRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.migrationhub.model.ListMigrationTasksRequest =
      zio.aws.migrationhub.model.ListMigrationTasksRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        resourceName.map(value => value)
      )
    def nextToken: Optional[Token]
    def maxResults: Optional[MaxResults]
    def resourceName: Optional[ResourceName]
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getResourceName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("resourceName", resourceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhub.model.ListMigrationTasksRequest
  ) extends zio.aws.migrationhub.model.ListMigrationTasksRequest.ReadOnly {
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.migrationhub.model.primitives.Token(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.migrationhub.model.primitives.MaxResults(value))
    override val resourceName: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceName())
      .map(value => zio.aws.migrationhub.model.primitives.ResourceName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhub.model.ListMigrationTasksRequest
  ): zio.aws.migrationhub.model.ListMigrationTasksRequest.ReadOnly =
    new Wrapper(impl)
}
