package zio.aws.migrationhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.migrationhub.model.primitives.{
  DryRun,
  MigrationTaskName,
  ProgressUpdateStream
}
import scala.jdk.CollectionConverters._
final case class PutResourceAttributesRequest(
    progressUpdateStream: ProgressUpdateStream,
    migrationTaskName: MigrationTaskName,
    resourceAttributeList: Iterable[
      zio.aws.migrationhub.model.ResourceAttribute
    ],
    dryRun: Optional[DryRun] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhub.model.PutResourceAttributesRequest = {
    import PutResourceAttributesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhub.model.PutResourceAttributesRequest
      .builder()
      .progressUpdateStream(
        ProgressUpdateStream.unwrap(progressUpdateStream): java.lang.String
      )
      .migrationTaskName(
        MigrationTaskName.unwrap(migrationTaskName): java.lang.String
      )
      .resourceAttributeList(resourceAttributeList.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        dryRun.map(value => DryRun.unwrap(value): java.lang.Boolean)
      )(_.dryRun)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhub.model.PutResourceAttributesRequest.ReadOnly =
    zio.aws.migrationhub.model.PutResourceAttributesRequest
      .wrap(buildAwsValue())
}
object PutResourceAttributesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhub.model.PutResourceAttributesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.migrationhub.model.PutResourceAttributesRequest =
      zio.aws.migrationhub.model.PutResourceAttributesRequest(
        progressUpdateStream,
        migrationTaskName,
        resourceAttributeList.map { item =>
          item.asEditable
        },
        dryRun.map(value => value)
      )
    def progressUpdateStream: ProgressUpdateStream
    def migrationTaskName: MigrationTaskName
    def resourceAttributeList
        : List[zio.aws.migrationhub.model.ResourceAttribute.ReadOnly]
    def dryRun: Optional[DryRun]
    def getProgressUpdateStream: ZIO[Any, Nothing, ProgressUpdateStream] =
      ZIO.succeed(progressUpdateStream)
    def getMigrationTaskName: ZIO[Any, Nothing, MigrationTaskName] =
      ZIO.succeed(migrationTaskName)
    def getResourceAttributeList: ZIO[Any, Nothing, List[
      zio.aws.migrationhub.model.ResourceAttribute.ReadOnly
    ]] = ZIO.succeed(resourceAttributeList)
    def getDryRun: ZIO[Any, AwsError, DryRun] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhub.model.PutResourceAttributesRequest
  ) extends zio.aws.migrationhub.model.PutResourceAttributesRequest.ReadOnly {
    override val progressUpdateStream: ProgressUpdateStream =
      zio.aws.migrationhub.model.primitives
        .ProgressUpdateStream(impl.progressUpdateStream())
    override val migrationTaskName: MigrationTaskName =
      zio.aws.migrationhub.model.primitives
        .MigrationTaskName(impl.migrationTaskName())
    override val resourceAttributeList
        : List[zio.aws.migrationhub.model.ResourceAttribute.ReadOnly] = impl
      .resourceAttributeList()
      .asScala
      .map { item =>
        zio.aws.migrationhub.model.ResourceAttribute.wrap(item)
      }
      .toList
    override val dryRun: Optional[DryRun] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => zio.aws.migrationhub.model.primitives.DryRun(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhub.model.PutResourceAttributesRequest
  ): zio.aws.migrationhub.model.PutResourceAttributesRequest.ReadOnly =
    new Wrapper(impl)
}
