package zio.aws.migrationhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.migrationhub.model.primitives.{
  DiscoveredResourceDescription,
  ConfigurationId
}
import scala.jdk.CollectionConverters._
final case class DiscoveredResource(
    configurationId: ConfigurationId,
    description: Optional[DiscoveredResourceDescription] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhub.model.DiscoveredResource = {
    import DiscoveredResource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhub.model.DiscoveredResource
      .builder()
      .configurationId(
        ConfigurationId.unwrap(configurationId): java.lang.String
      )
      .optionallyWith(
        description.map(value =>
          DiscoveredResourceDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.migrationhub.model.DiscoveredResource.ReadOnly =
    zio.aws.migrationhub.model.DiscoveredResource.wrap(buildAwsValue())
}
object DiscoveredResource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhub.model.DiscoveredResource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.migrationhub.model.DiscoveredResource =
      zio.aws.migrationhub.model
        .DiscoveredResource(configurationId, description.map(value => value))
    def configurationId: ConfigurationId
    def description: Optional[DiscoveredResourceDescription]
    def getConfigurationId: ZIO[Any, Nothing, ConfigurationId] =
      ZIO.succeed(configurationId)
    def getDescription: ZIO[Any, AwsError, DiscoveredResourceDescription] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhub.model.DiscoveredResource
  ) extends zio.aws.migrationhub.model.DiscoveredResource.ReadOnly {
    override val configurationId: ConfigurationId =
      zio.aws.migrationhub.model.primitives
        .ConfigurationId(impl.configurationId())
    override val description: Optional[DiscoveredResourceDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.migrationhub.model.primitives
            .DiscoveredResourceDescription(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhub.model.DiscoveredResource
  ): zio.aws.migrationhub.model.DiscoveredResource.ReadOnly = new Wrapper(impl)
}
