package zio.aws.migrationhub.model
import zio.aws.migrationhub.model.primitives.{UpdateDateTime, ApplicationId}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ApplicationState(
    applicationId: Optional[ApplicationId] = Optional.Absent,
    applicationStatus: Optional[zio.aws.migrationhub.model.ApplicationStatus] =
      Optional.Absent,
    lastUpdatedTime: Optional[UpdateDateTime] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhub.model.ApplicationState = {
    import ApplicationState.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhub.model.ApplicationState
      .builder()
      .optionallyWith(
        applicationId.map(value =>
          ApplicationId.unwrap(value): java.lang.String
        )
      )(_.applicationId)
      .optionallyWith(applicationStatus.map(value => value.unwrap))(
        _.applicationStatus
      )
      .optionallyWith(
        lastUpdatedTime.map(value => UpdateDateTime.unwrap(value): Instant)
      )(_.lastUpdatedTime)
      .build()
  }
  def asReadOnly: zio.aws.migrationhub.model.ApplicationState.ReadOnly =
    zio.aws.migrationhub.model.ApplicationState.wrap(buildAwsValue())
}
object ApplicationState {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhub.model.ApplicationState
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.migrationhub.model.ApplicationState =
      zio.aws.migrationhub.model.ApplicationState(
        applicationId.map(value => value),
        applicationStatus.map(value => value),
        lastUpdatedTime.map(value => value)
      )
    def applicationId: Optional[ApplicationId]
    def applicationStatus
        : Optional[zio.aws.migrationhub.model.ApplicationStatus]
    def lastUpdatedTime: Optional[UpdateDateTime]
    def getApplicationId: ZIO[Any, AwsError, ApplicationId] =
      AwsError.unwrapOptionField("applicationId", applicationId)
    def getApplicationStatus
        : ZIO[Any, AwsError, zio.aws.migrationhub.model.ApplicationStatus] =
      AwsError.unwrapOptionField("applicationStatus", applicationStatus)
    def getLastUpdatedTime: ZIO[Any, AwsError, UpdateDateTime] =
      AwsError.unwrapOptionField("lastUpdatedTime", lastUpdatedTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhub.model.ApplicationState
  ) extends zio.aws.migrationhub.model.ApplicationState.ReadOnly {
    override val applicationId: Optional[ApplicationId] = zio.aws.core.internal
      .optionalFromNullable(impl.applicationId())
      .map(value => zio.aws.migrationhub.model.primitives.ApplicationId(value))
    override val applicationStatus
        : Optional[zio.aws.migrationhub.model.ApplicationStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.applicationStatus())
        .map(value => zio.aws.migrationhub.model.ApplicationStatus.wrap(value))
    override val lastUpdatedTime: Optional[UpdateDateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdatedTime())
        .map(value =>
          zio.aws.migrationhub.model.primitives.UpdateDateTime(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhub.model.ApplicationState
  ): zio.aws.migrationhub.model.ApplicationState.ReadOnly = new Wrapper(impl)
}
