package zio.aws.migrationhub.model
import zio.aws.migrationhub.model.primitives.{
  NextUpdateSeconds,
  ProgressUpdateStream,
  MigrationTaskName,
  UpdateDateTime,
  DryRun
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class NotifyMigrationTaskStateRequest(
    progressUpdateStream: ProgressUpdateStream,
    migrationTaskName: MigrationTaskName,
    task: zio.aws.migrationhub.model.Task,
    updateDateTime: UpdateDateTime,
    nextUpdateSeconds: NextUpdateSeconds,
    dryRun: Optional[DryRun] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhub.model.NotifyMigrationTaskStateRequest = {
    import NotifyMigrationTaskStateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhub.model.NotifyMigrationTaskStateRequest
      .builder()
      .progressUpdateStream(
        ProgressUpdateStream.unwrap(progressUpdateStream): java.lang.String
      )
      .migrationTaskName(
        MigrationTaskName.unwrap(migrationTaskName): java.lang.String
      )
      .task(task.buildAwsValue())
      .updateDateTime(UpdateDateTime.unwrap(updateDateTime): Instant)
      .nextUpdateSeconds(NextUpdateSeconds.unwrap(nextUpdateSeconds): Integer)
      .optionallyWith(
        dryRun.map(value => DryRun.unwrap(value): java.lang.Boolean)
      )(_.dryRun)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhub.model.NotifyMigrationTaskStateRequest.ReadOnly =
    zio.aws.migrationhub.model.NotifyMigrationTaskStateRequest
      .wrap(buildAwsValue())
}
object NotifyMigrationTaskStateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhub.model.NotifyMigrationTaskStateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.migrationhub.model.NotifyMigrationTaskStateRequest =
      zio.aws.migrationhub.model.NotifyMigrationTaskStateRequest(
        progressUpdateStream,
        migrationTaskName,
        task.asEditable,
        updateDateTime,
        nextUpdateSeconds,
        dryRun.map(value => value)
      )
    def progressUpdateStream: ProgressUpdateStream
    def migrationTaskName: MigrationTaskName
    def task: zio.aws.migrationhub.model.Task.ReadOnly
    def updateDateTime: UpdateDateTime
    def nextUpdateSeconds: NextUpdateSeconds
    def dryRun: Optional[DryRun]
    def getProgressUpdateStream: ZIO[Any, Nothing, ProgressUpdateStream] =
      ZIO.succeed(progressUpdateStream)
    def getMigrationTaskName: ZIO[Any, Nothing, MigrationTaskName] =
      ZIO.succeed(migrationTaskName)
    def getTask: ZIO[Any, Nothing, zio.aws.migrationhub.model.Task.ReadOnly] =
      ZIO.succeed(task)
    def getUpdateDateTime: ZIO[Any, Nothing, UpdateDateTime] =
      ZIO.succeed(updateDateTime)
    def getNextUpdateSeconds: ZIO[Any, Nothing, NextUpdateSeconds] =
      ZIO.succeed(nextUpdateSeconds)
    def getDryRun: ZIO[Any, AwsError, DryRun] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhub.model.NotifyMigrationTaskStateRequest
  ) extends zio.aws.migrationhub.model.NotifyMigrationTaskStateRequest.ReadOnly {
    override val progressUpdateStream: ProgressUpdateStream =
      zio.aws.migrationhub.model.primitives
        .ProgressUpdateStream(impl.progressUpdateStream())
    override val migrationTaskName: MigrationTaskName =
      zio.aws.migrationhub.model.primitives
        .MigrationTaskName(impl.migrationTaskName())
    override val task: zio.aws.migrationhub.model.Task.ReadOnly =
      zio.aws.migrationhub.model.Task.wrap(impl.task())
    override val updateDateTime: UpdateDateTime =
      zio.aws.migrationhub.model.primitives
        .UpdateDateTime(impl.updateDateTime())
    override val nextUpdateSeconds: NextUpdateSeconds =
      zio.aws.migrationhub.model.primitives
        .NextUpdateSeconds(impl.nextUpdateSeconds())
    override val dryRun: Optional[DryRun] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => zio.aws.migrationhub.model.primitives.DryRun(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhub.model.NotifyMigrationTaskStateRequest
  ): zio.aws.migrationhub.model.NotifyMigrationTaskStateRequest.ReadOnly =
    new Wrapper(impl)
}
