package zio.aws.migrationhub.model
import scala.jdk.CollectionConverters._
sealed trait ApplicationStatus {
  def unwrap
      : software.amazon.awssdk.services.migrationhub.model.ApplicationStatus
}
object ApplicationStatus {
  def wrap(
      value: software.amazon.awssdk.services.migrationhub.model.ApplicationStatus
  ): zio.aws.migrationhub.model.ApplicationStatus = value match {
    case software.amazon.awssdk.services.migrationhub.model.ApplicationStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.migrationhub.model.ApplicationStatus.NOT_STARTED =>
      val r = NOT_STARTED
      r
    case software.amazon.awssdk.services.migrationhub.model.ApplicationStatus.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
    case software.amazon.awssdk.services.migrationhub.model.ApplicationStatus.COMPLETED =>
      val r = COMPLETED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.migrationhub.model.ApplicationStatus {
    override def unwrap
        : software.amazon.awssdk.services.migrationhub.model.ApplicationStatus =
      software.amazon.awssdk.services.migrationhub.model.ApplicationStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object NOT_STARTED extends zio.aws.migrationhub.model.ApplicationStatus {
    override def unwrap
        : software.amazon.awssdk.services.migrationhub.model.ApplicationStatus =
      software.amazon.awssdk.services.migrationhub.model.ApplicationStatus.NOT_STARTED
  }
  case object IN_PROGRESS extends zio.aws.migrationhub.model.ApplicationStatus {
    override def unwrap
        : software.amazon.awssdk.services.migrationhub.model.ApplicationStatus =
      software.amazon.awssdk.services.migrationhub.model.ApplicationStatus.IN_PROGRESS
  }
  case object COMPLETED extends zio.aws.migrationhub.model.ApplicationStatus {
    override def unwrap
        : software.amazon.awssdk.services.migrationhub.model.ApplicationStatus =
      software.amazon.awssdk.services.migrationhub.model.ApplicationStatus.COMPLETED
  }
}
