package zio.aws.migrationhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.migrationhub.model.primitives.{
  CreatedArtifactDescription,
  CreatedArtifactName
}
import scala.jdk.CollectionConverters._
final case class CreatedArtifact(
    name: CreatedArtifactName,
    description: Optional[CreatedArtifactDescription] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhub.model.CreatedArtifact = {
    import CreatedArtifact.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhub.model.CreatedArtifact
      .builder()
      .name(CreatedArtifactName.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value =>
          CreatedArtifactDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.migrationhub.model.CreatedArtifact.ReadOnly =
    zio.aws.migrationhub.model.CreatedArtifact.wrap(buildAwsValue())
}
object CreatedArtifact {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhub.model.CreatedArtifact
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.migrationhub.model.CreatedArtifact =
      zio.aws.migrationhub.model
        .CreatedArtifact(name, description.map(value => value))
    def name: CreatedArtifactName
    def description: Optional[CreatedArtifactDescription]
    def getName: ZIO[Any, Nothing, CreatedArtifactName] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, CreatedArtifactDescription] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhub.model.CreatedArtifact
  ) extends zio.aws.migrationhub.model.CreatedArtifact.ReadOnly {
    override val name: CreatedArtifactName =
      zio.aws.migrationhub.model.primitives.CreatedArtifactName(impl.name())
    override val description: Optional[CreatedArtifactDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.migrationhub.model.primitives
            .CreatedArtifactDescription(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhub.model.CreatedArtifact
  ): zio.aws.migrationhub.model.CreatedArtifact.ReadOnly = new Wrapper(impl)
}
