package zio.aws.migrationhub.model
import scala.jdk.CollectionConverters._
sealed trait Status {
  def unwrap: software.amazon.awssdk.services.migrationhub.model.Status
}
object Status {
  def wrap(
      value: software.amazon.awssdk.services.migrationhub.model.Status
  ): zio.aws.migrationhub.model.Status = value match {
    case software.amazon.awssdk.services.migrationhub.model.Status.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.migrationhub.model.Status.NOT_STARTED =>
      val r = NOT_STARTED
      r
    case software.amazon.awssdk.services.migrationhub.model.Status.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
    case software.amazon.awssdk.services.migrationhub.model.Status.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.migrationhub.model.Status.COMPLETED =>
      val r = COMPLETED
      r
  }
  case object unknownToSdkVersion extends zio.aws.migrationhub.model.Status {
    override def unwrap
        : software.amazon.awssdk.services.migrationhub.model.Status =
      software.amazon.awssdk.services.migrationhub.model.Status.UNKNOWN_TO_SDK_VERSION
  }
  case object NOT_STARTED extends zio.aws.migrationhub.model.Status {
    override def unwrap
        : software.amazon.awssdk.services.migrationhub.model.Status =
      software.amazon.awssdk.services.migrationhub.model.Status.NOT_STARTED
  }
  case object IN_PROGRESS extends zio.aws.migrationhub.model.Status {
    override def unwrap
        : software.amazon.awssdk.services.migrationhub.model.Status =
      software.amazon.awssdk.services.migrationhub.model.Status.IN_PROGRESS
  }
  case object FAILED extends zio.aws.migrationhub.model.Status {
    override def unwrap
        : software.amazon.awssdk.services.migrationhub.model.Status =
      software.amazon.awssdk.services.migrationhub.model.Status.FAILED
  }
  case object COMPLETED extends zio.aws.migrationhub.model.Status {
    override def unwrap
        : software.amazon.awssdk.services.migrationhub.model.Status =
      software.amazon.awssdk.services.migrationhub.model.Status.COMPLETED
  }
}
