package zio.aws.migrationhub.model
import zio.aws.migrationhub.model.primitives.{MaxResults, Token}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListProgressUpdateStreamsRequest(
    nextToken: Optional[Token] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhub.model.ListProgressUpdateStreamsRequest = {
    import ListProgressUpdateStreamsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhub.model.ListProgressUpdateStreamsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhub.model.ListProgressUpdateStreamsRequest.ReadOnly =
    zio.aws.migrationhub.model.ListProgressUpdateStreamsRequest
      .wrap(buildAwsValue())
}
object ListProgressUpdateStreamsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhub.model.ListProgressUpdateStreamsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhub.model.ListProgressUpdateStreamsRequest =
      zio.aws.migrationhub.model.ListProgressUpdateStreamsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def nextToken: Optional[Token]
    def maxResults: Optional[MaxResults]
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhub.model.ListProgressUpdateStreamsRequest
  ) extends zio.aws.migrationhub.model.ListProgressUpdateStreamsRequest.ReadOnly {
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.migrationhub.model.primitives.Token(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.migrationhub.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhub.model.ListProgressUpdateStreamsRequest
  ): zio.aws.migrationhub.model.ListProgressUpdateStreamsRequest.ReadOnly =
    new Wrapper(impl)
}
