package zio.aws.migrationhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.migrationhub.model.primitives.Token
import scala.jdk.CollectionConverters._
final case class ListApplicationStatesResponse(
    applicationStateList: Optional[
      Iterable[zio.aws.migrationhub.model.ApplicationState]
    ] = Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhub.model.ListApplicationStatesResponse = {
    import ListApplicationStatesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhub.model.ListApplicationStatesResponse
      .builder()
      .optionallyWith(
        applicationStateList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.applicationStateList)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhub.model.ListApplicationStatesResponse.ReadOnly =
    zio.aws.migrationhub.model.ListApplicationStatesResponse
      .wrap(buildAwsValue())
}
object ListApplicationStatesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhub.model.ListApplicationStatesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.migrationhub.model.ListApplicationStatesResponse =
      zio.aws.migrationhub.model.ListApplicationStatesResponse(
        applicationStateList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def applicationStateList
        : Optional[List[zio.aws.migrationhub.model.ApplicationState.ReadOnly]]
    def nextToken: Optional[Token]
    def getApplicationStateList: ZIO[Any, AwsError, List[
      zio.aws.migrationhub.model.ApplicationState.ReadOnly
    ]] =
      AwsError.unwrapOptionField("applicationStateList", applicationStateList)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhub.model.ListApplicationStatesResponse
  ) extends zio.aws.migrationhub.model.ListApplicationStatesResponse.ReadOnly {
    override val applicationStateList
        : Optional[List[zio.aws.migrationhub.model.ApplicationState.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.applicationStateList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.migrationhub.model.ApplicationState.wrap(item)
          }.toList
        )
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.migrationhub.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhub.model.ListApplicationStatesResponse
  ): zio.aws.migrationhub.model.ListApplicationStatesResponse.ReadOnly =
    new Wrapper(impl)
}
