package zio.aws.migrationhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.migrationhub.model.primitives.{
  DryRun,
  ConfigurationId,
  MigrationTaskName,
  ProgressUpdateStream
}
import scala.jdk.CollectionConverters._
final case class DisassociateDiscoveredResourceRequest(
    progressUpdateStream: ProgressUpdateStream,
    migrationTaskName: MigrationTaskName,
    configurationId: ConfigurationId,
    dryRun: Optional[DryRun] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhub.model.DisassociateDiscoveredResourceRequest = {
    import DisassociateDiscoveredResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhub.model.DisassociateDiscoveredResourceRequest
      .builder()
      .progressUpdateStream(
        ProgressUpdateStream.unwrap(progressUpdateStream): java.lang.String
      )
      .migrationTaskName(
        MigrationTaskName.unwrap(migrationTaskName): java.lang.String
      )
      .configurationId(
        ConfigurationId.unwrap(configurationId): java.lang.String
      )
      .optionallyWith(
        dryRun.map(value => DryRun.unwrap(value): java.lang.Boolean)
      )(_.dryRun)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhub.model.DisassociateDiscoveredResourceRequest.ReadOnly =
    zio.aws.migrationhub.model.DisassociateDiscoveredResourceRequest
      .wrap(buildAwsValue())
}
object DisassociateDiscoveredResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhub.model.DisassociateDiscoveredResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhub.model.DisassociateDiscoveredResourceRequest =
      zio.aws.migrationhub.model.DisassociateDiscoveredResourceRequest(
        progressUpdateStream,
        migrationTaskName,
        configurationId,
        dryRun.map(value => value)
      )
    def progressUpdateStream: ProgressUpdateStream
    def migrationTaskName: MigrationTaskName
    def configurationId: ConfigurationId
    def dryRun: Optional[DryRun]
    def getProgressUpdateStream: ZIO[Any, Nothing, ProgressUpdateStream] =
      ZIO.succeed(progressUpdateStream)
    def getMigrationTaskName: ZIO[Any, Nothing, MigrationTaskName] =
      ZIO.succeed(migrationTaskName)
    def getConfigurationId: ZIO[Any, Nothing, ConfigurationId] =
      ZIO.succeed(configurationId)
    def getDryRun: ZIO[Any, AwsError, DryRun] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhub.model.DisassociateDiscoveredResourceRequest
  ) extends zio.aws.migrationhub.model.DisassociateDiscoveredResourceRequest.ReadOnly {
    override val progressUpdateStream: ProgressUpdateStream =
      zio.aws.migrationhub.model.primitives
        .ProgressUpdateStream(impl.progressUpdateStream())
    override val migrationTaskName: MigrationTaskName =
      zio.aws.migrationhub.model.primitives
        .MigrationTaskName(impl.migrationTaskName())
    override val configurationId: ConfigurationId =
      zio.aws.migrationhub.model.primitives
        .ConfigurationId(impl.configurationId())
    override val dryRun: Optional[DryRun] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => zio.aws.migrationhub.model.primitives.DryRun(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhub.model.DisassociateDiscoveredResourceRequest
  ): zio.aws.migrationhub.model.DisassociateDiscoveredResourceRequest.ReadOnly =
    new Wrapper(impl)
}
