package zio.aws.migrationhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.migrationhub.model.primitives.Token
import scala.jdk.CollectionConverters._
final case class ListCreatedArtifactsResponse(
    nextToken: Optional[Token] = Optional.Absent,
    createdArtifactList: Optional[
      Iterable[zio.aws.migrationhub.model.CreatedArtifact]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhub.model.ListCreatedArtifactsResponse = {
    import ListCreatedArtifactsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhub.model.ListCreatedArtifactsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        createdArtifactList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.createdArtifactList)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhub.model.ListCreatedArtifactsResponse.ReadOnly =
    zio.aws.migrationhub.model.ListCreatedArtifactsResponse
      .wrap(buildAwsValue())
}
object ListCreatedArtifactsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhub.model.ListCreatedArtifactsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.migrationhub.model.ListCreatedArtifactsResponse =
      zio.aws.migrationhub.model.ListCreatedArtifactsResponse(
        nextToken.map(value => value),
        createdArtifactList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[Token]
    def createdArtifactList
        : Optional[List[zio.aws.migrationhub.model.CreatedArtifact.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getCreatedArtifactList: ZIO[Any, AwsError, List[
      zio.aws.migrationhub.model.CreatedArtifact.ReadOnly
    ]] = AwsError.unwrapOptionField("createdArtifactList", createdArtifactList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhub.model.ListCreatedArtifactsResponse
  ) extends zio.aws.migrationhub.model.ListCreatedArtifactsResponse.ReadOnly {
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.migrationhub.model.primitives.Token(value))
    override val createdArtifactList
        : Optional[List[zio.aws.migrationhub.model.CreatedArtifact.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdArtifactList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.migrationhub.model.CreatedArtifact.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhub.model.ListCreatedArtifactsResponse
  ): zio.aws.migrationhub.model.ListCreatedArtifactsResponse.ReadOnly =
    new Wrapper(impl)
}
