package zio.aws.migrationhub.model
import zio.aws.migrationhub.model.primitives.{MaxResults, Token, ApplicationId}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListApplicationStatesRequest(
    applicationIds: Optional[Iterable[ApplicationId]] = Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhub.model.ListApplicationStatesRequest = {
    import ListApplicationStatesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhub.model.ListApplicationStatesRequest
      .builder()
      .optionallyWith(
        applicationIds.map(value =>
          value.map { item =>
            ApplicationId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.applicationIds)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhub.model.ListApplicationStatesRequest.ReadOnly =
    zio.aws.migrationhub.model.ListApplicationStatesRequest
      .wrap(buildAwsValue())
}
object ListApplicationStatesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhub.model.ListApplicationStatesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.migrationhub.model.ListApplicationStatesRequest =
      zio.aws.migrationhub.model.ListApplicationStatesRequest(
        applicationIds.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def applicationIds: Optional[List[ApplicationId]]
    def nextToken: Optional[Token]
    def maxResults: Optional[MaxResults]
    def getApplicationIds: ZIO[Any, AwsError, List[ApplicationId]] =
      AwsError.unwrapOptionField("applicationIds", applicationIds)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhub.model.ListApplicationStatesRequest
  ) extends zio.aws.migrationhub.model.ListApplicationStatesRequest.ReadOnly {
    override val applicationIds: Optional[List[ApplicationId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.applicationIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.migrationhub.model.primitives.ApplicationId(item)
          }.toList
        )
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.migrationhub.model.primitives.Token(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.migrationhub.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhub.model.ListApplicationStatesRequest
  ): zio.aws.migrationhub.model.ListApplicationStatesRequest.ReadOnly =
    new Wrapper(impl)
}
