package zio.aws.migrationhub.model
import zio.aws.migrationhub.model.primitives.{
  ProgressPercent,
  ProgressUpdateStream,
  MigrationTaskName,
  UpdateDateTime,
  StatusDetail
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class MigrationTaskSummary(
    progressUpdateStream: Optional[ProgressUpdateStream] = Optional.Absent,
    migrationTaskName: Optional[MigrationTaskName] = Optional.Absent,
    status: Optional[zio.aws.migrationhub.model.Status] = Optional.Absent,
    progressPercent: Optional[ProgressPercent] = Optional.Absent,
    statusDetail: Optional[StatusDetail] = Optional.Absent,
    updateDateTime: Optional[UpdateDateTime] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhub.model.MigrationTaskSummary = {
    import MigrationTaskSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhub.model.MigrationTaskSummary
      .builder()
      .optionallyWith(
        progressUpdateStream.map(value =>
          ProgressUpdateStream.unwrap(value): java.lang.String
        )
      )(_.progressUpdateStream)
      .optionallyWith(
        migrationTaskName.map(value =>
          MigrationTaskName.unwrap(value): java.lang.String
        )
      )(_.migrationTaskName)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        progressPercent.map(value => ProgressPercent.unwrap(value): Integer)
      )(_.progressPercent)
      .optionallyWith(
        statusDetail.map(value => StatusDetail.unwrap(value): java.lang.String)
      )(_.statusDetail)
      .optionallyWith(
        updateDateTime.map(value => UpdateDateTime.unwrap(value): Instant)
      )(_.updateDateTime)
      .build()
  }
  def asReadOnly: zio.aws.migrationhub.model.MigrationTaskSummary.ReadOnly =
    zio.aws.migrationhub.model.MigrationTaskSummary.wrap(buildAwsValue())
}
object MigrationTaskSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhub.model.MigrationTaskSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.migrationhub.model.MigrationTaskSummary =
      zio.aws.migrationhub.model.MigrationTaskSummary(
        progressUpdateStream.map(value => value),
        migrationTaskName.map(value => value),
        status.map(value => value),
        progressPercent.map(value => value),
        statusDetail.map(value => value),
        updateDateTime.map(value => value)
      )
    def progressUpdateStream: Optional[ProgressUpdateStream]
    def migrationTaskName: Optional[MigrationTaskName]
    def status: Optional[zio.aws.migrationhub.model.Status]
    def progressPercent: Optional[ProgressPercent]
    def statusDetail: Optional[StatusDetail]
    def updateDateTime: Optional[UpdateDateTime]
    def getProgressUpdateStream: ZIO[Any, AwsError, ProgressUpdateStream] =
      AwsError.unwrapOptionField("progressUpdateStream", progressUpdateStream)
    def getMigrationTaskName: ZIO[Any, AwsError, MigrationTaskName] =
      AwsError.unwrapOptionField("migrationTaskName", migrationTaskName)
    def getStatus: ZIO[Any, AwsError, zio.aws.migrationhub.model.Status] =
      AwsError.unwrapOptionField("status", status)
    def getProgressPercent: ZIO[Any, AwsError, ProgressPercent] =
      AwsError.unwrapOptionField("progressPercent", progressPercent)
    def getStatusDetail: ZIO[Any, AwsError, StatusDetail] =
      AwsError.unwrapOptionField("statusDetail", statusDetail)
    def getUpdateDateTime: ZIO[Any, AwsError, UpdateDateTime] =
      AwsError.unwrapOptionField("updateDateTime", updateDateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhub.model.MigrationTaskSummary
  ) extends zio.aws.migrationhub.model.MigrationTaskSummary.ReadOnly {
    override val progressUpdateStream: Optional[ProgressUpdateStream] =
      zio.aws.core.internal
        .optionalFromNullable(impl.progressUpdateStream())
        .map(value =>
          zio.aws.migrationhub.model.primitives.ProgressUpdateStream(value)
        )
    override val migrationTaskName: Optional[MigrationTaskName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.migrationTaskName())
        .map(value =>
          zio.aws.migrationhub.model.primitives.MigrationTaskName(value)
        )
    override val status: Optional[zio.aws.migrationhub.model.Status] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.migrationhub.model.Status.wrap(value))
    override val progressPercent: Optional[ProgressPercent] =
      zio.aws.core.internal
        .optionalFromNullable(impl.progressPercent())
        .map(value =>
          zio.aws.migrationhub.model.primitives.ProgressPercent(value)
        )
    override val statusDetail: Optional[StatusDetail] = zio.aws.core.internal
      .optionalFromNullable(impl.statusDetail())
      .map(value => zio.aws.migrationhub.model.primitives.StatusDetail(value))
    override val updateDateTime: Optional[UpdateDateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.updateDateTime())
        .map(value =>
          zio.aws.migrationhub.model.primitives.UpdateDateTime(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhub.model.MigrationTaskSummary
  ): zio.aws.migrationhub.model.MigrationTaskSummary.ReadOnly = new Wrapper(
    impl
  )
}
