package zio.aws.migrationhub.model
import zio.aws.migrationhub.model.primitives.{
  MaxResultsResources,
  Token,
  MigrationTaskName,
  ProgressUpdateStream
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListDiscoveredResourcesRequest(
    progressUpdateStream: ProgressUpdateStream,
    migrationTaskName: MigrationTaskName,
    nextToken: Optional[Token] = Optional.Absent,
    maxResults: Optional[MaxResultsResources] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhub.model.ListDiscoveredResourcesRequest = {
    import ListDiscoveredResourcesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhub.model.ListDiscoveredResourcesRequest
      .builder()
      .progressUpdateStream(
        ProgressUpdateStream.unwrap(progressUpdateStream): java.lang.String
      )
      .migrationTaskName(
        MigrationTaskName.unwrap(migrationTaskName): java.lang.String
      )
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResultsResources.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhub.model.ListDiscoveredResourcesRequest.ReadOnly =
    zio.aws.migrationhub.model.ListDiscoveredResourcesRequest
      .wrap(buildAwsValue())
}
object ListDiscoveredResourcesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhub.model.ListDiscoveredResourcesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.migrationhub.model.ListDiscoveredResourcesRequest =
      zio.aws.migrationhub.model.ListDiscoveredResourcesRequest(
        progressUpdateStream,
        migrationTaskName,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def progressUpdateStream: ProgressUpdateStream
    def migrationTaskName: MigrationTaskName
    def nextToken: Optional[Token]
    def maxResults: Optional[MaxResultsResources]
    def getProgressUpdateStream: ZIO[Any, Nothing, ProgressUpdateStream] =
      ZIO.succeed(progressUpdateStream)
    def getMigrationTaskName: ZIO[Any, Nothing, MigrationTaskName] =
      ZIO.succeed(migrationTaskName)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResultsResources] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhub.model.ListDiscoveredResourcesRequest
  ) extends zio.aws.migrationhub.model.ListDiscoveredResourcesRequest.ReadOnly {
    override val progressUpdateStream: ProgressUpdateStream =
      zio.aws.migrationhub.model.primitives
        .ProgressUpdateStream(impl.progressUpdateStream())
    override val migrationTaskName: MigrationTaskName =
      zio.aws.migrationhub.model.primitives
        .MigrationTaskName(impl.migrationTaskName())
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.migrationhub.model.primitives.Token(value))
    override val maxResults: Optional[MaxResultsResources] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.migrationhub.model.primitives.MaxResultsResources(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhub.model.ListDiscoveredResourcesRequest
  ): zio.aws.migrationhub.model.ListDiscoveredResourcesRequest.ReadOnly =
    new Wrapper(impl)
}
