package zio.aws.migrationhub.model
import zio.aws.migrationhub.model.primitives.UpdateDateTime
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DescribeApplicationStateResponse(
    applicationStatus: Optional[zio.aws.migrationhub.model.ApplicationStatus] =
      Optional.Absent,
    lastUpdatedTime: Optional[UpdateDateTime] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhub.model.DescribeApplicationStateResponse = {
    import DescribeApplicationStateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhub.model.DescribeApplicationStateResponse
      .builder()
      .optionallyWith(applicationStatus.map(value => value.unwrap))(
        _.applicationStatus
      )
      .optionallyWith(
        lastUpdatedTime.map(value => UpdateDateTime.unwrap(value): Instant)
      )(_.lastUpdatedTime)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhub.model.DescribeApplicationStateResponse.ReadOnly =
    zio.aws.migrationhub.model.DescribeApplicationStateResponse
      .wrap(buildAwsValue())
}
object DescribeApplicationStateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhub.model.DescribeApplicationStateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhub.model.DescribeApplicationStateResponse =
      zio.aws.migrationhub.model.DescribeApplicationStateResponse(
        applicationStatus.map(value => value),
        lastUpdatedTime.map(value => value)
      )
    def applicationStatus
        : Optional[zio.aws.migrationhub.model.ApplicationStatus]
    def lastUpdatedTime: Optional[UpdateDateTime]
    def getApplicationStatus
        : ZIO[Any, AwsError, zio.aws.migrationhub.model.ApplicationStatus] =
      AwsError.unwrapOptionField("applicationStatus", applicationStatus)
    def getLastUpdatedTime: ZIO[Any, AwsError, UpdateDateTime] =
      AwsError.unwrapOptionField("lastUpdatedTime", lastUpdatedTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhub.model.DescribeApplicationStateResponse
  ) extends zio.aws.migrationhub.model.DescribeApplicationStateResponse.ReadOnly {
    override val applicationStatus
        : Optional[zio.aws.migrationhub.model.ApplicationStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.applicationStatus())
        .map(value => zio.aws.migrationhub.model.ApplicationStatus.wrap(value))
    override val lastUpdatedTime: Optional[UpdateDateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdatedTime())
        .map(value =>
          zio.aws.migrationhub.model.primitives.UpdateDateTime(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhub.model.DescribeApplicationStateResponse
  ): zio.aws.migrationhub.model.DescribeApplicationStateResponse.ReadOnly =
    new Wrapper(impl)
}
