package zio.aws.migrationhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.migrationhub.model.primitives.{
  DryRun,
  UpdateDateTime,
  ApplicationId
}
import scala.jdk.CollectionConverters._
final case class NotifyApplicationStateRequest(
    applicationId: ApplicationId,
    status: zio.aws.migrationhub.model.ApplicationStatus,
    updateDateTime: Option[UpdateDateTime] = None,
    dryRun: Option[DryRun] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhub.model.NotifyApplicationStateRequest = {
    import NotifyApplicationStateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhub.model.NotifyApplicationStateRequest
      .builder()
      .applicationId(ApplicationId.unwrap(applicationId): java.lang.String)
      .status(status.unwrap)
      .optionallyWith(
        updateDateTime.map(value => UpdateDateTime.unwrap(value): Instant)
      )(_.updateDateTime)
      .optionallyWith(
        dryRun.map(value => DryRun.unwrap(value): java.lang.Boolean)
      )(_.dryRun)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhub.model.NotifyApplicationStateRequest.ReadOnly =
    zio.aws.migrationhub.model.NotifyApplicationStateRequest
      .wrap(buildAwsValue())
}
object NotifyApplicationStateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhub.model.NotifyApplicationStateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.migrationhub.model.NotifyApplicationStateRequest =
      zio.aws.migrationhub.model.NotifyApplicationStateRequest(
        applicationId,
        status,
        updateDateTime.map(value => value),
        dryRun.map(value => value)
      )
    def applicationId: ApplicationId
    def status: zio.aws.migrationhub.model.ApplicationStatus
    def updateDateTime: Option[UpdateDateTime]
    def dryRun: Option[DryRun]
    def getApplicationId: ZIO[Any, Nothing, ApplicationId] =
      ZIO.succeed(applicationId)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.migrationhub.model.ApplicationStatus] =
      ZIO.succeed(status)
    def getUpdateDateTime: ZIO[Any, AwsError, UpdateDateTime] =
      AwsError.unwrapOptionField("updateDateTime", updateDateTime)
    def getDryRun: ZIO[Any, AwsError, DryRun] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhub.model.NotifyApplicationStateRequest
  ) extends zio.aws.migrationhub.model.NotifyApplicationStateRequest.ReadOnly {
    override val applicationId: ApplicationId =
      zio.aws.migrationhub.model.primitives.ApplicationId(impl.applicationId())
    override val status: zio.aws.migrationhub.model.ApplicationStatus =
      zio.aws.migrationhub.model.ApplicationStatus.wrap(impl.status())
    override val updateDateTime: Option[UpdateDateTime] = scala
      .Option(impl.updateDateTime())
      .map(value => zio.aws.migrationhub.model.primitives.UpdateDateTime(value))
    override val dryRun: Option[DryRun] = scala
      .Option(impl.dryRun())
      .map(value => zio.aws.migrationhub.model.primitives.DryRun(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhub.model.NotifyApplicationStateRequest
  ): zio.aws.migrationhub.model.NotifyApplicationStateRequest.ReadOnly =
    new Wrapper(impl)
}
