package zio.aws.migrationhub.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.migrationhub.model.primitives.{ResourceName, MaxResults, Token}
import scala.jdk.CollectionConverters._
final case class ListMigrationTasksRequest(
    nextToken: Option[Token] = None,
    maxResults: Option[MaxResults] = None,
    resourceName: Option[ResourceName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhub.model.ListMigrationTasksRequest = {
    import ListMigrationTasksRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhub.model.ListMigrationTasksRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        resourceName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.resourceName)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhub.model.ListMigrationTasksRequest.ReadOnly =
    zio.aws.migrationhub.model.ListMigrationTasksRequest.wrap(buildAwsValue())
}
object ListMigrationTasksRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhub.model.ListMigrationTasksRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.migrationhub.model.ListMigrationTasksRequest =
      zio.aws.migrationhub.model.ListMigrationTasksRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        resourceName.map(value => value)
      )
    def nextToken: Option[Token]
    def maxResults: Option[MaxResults]
    def resourceName: Option[ResourceName]
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getResourceName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("resourceName", resourceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhub.model.ListMigrationTasksRequest
  ) extends zio.aws.migrationhub.model.ListMigrationTasksRequest.ReadOnly {
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.migrationhub.model.primitives.Token(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.migrationhub.model.primitives.MaxResults(value))
    override val resourceName: Option[ResourceName] = scala
      .Option(impl.resourceName())
      .map(value => zio.aws.migrationhub.model.primitives.ResourceName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhub.model.ListMigrationTasksRequest
  ): zio.aws.migrationhub.model.ListMigrationTasksRequest.ReadOnly =
    new Wrapper(impl)
}
