package zio.aws.migrationhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.migrationhub.model.primitives.Token
import scala.jdk.CollectionConverters._
final case class ListProgressUpdateStreamsResponse(
    progressUpdateStreamSummaryList: Option[
      Iterable[zio.aws.migrationhub.model.ProgressUpdateStreamSummary]
    ] = None,
    nextToken: Option[Token] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhub.model.ListProgressUpdateStreamsResponse = {
    import ListProgressUpdateStreamsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhub.model.ListProgressUpdateStreamsResponse
      .builder()
      .optionallyWith(
        progressUpdateStreamSummaryList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.progressUpdateStreamSummaryList)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhub.model.ListProgressUpdateStreamsResponse.ReadOnly =
    zio.aws.migrationhub.model.ListProgressUpdateStreamsResponse
      .wrap(buildAwsValue())
}
object ListProgressUpdateStreamsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhub.model.ListProgressUpdateStreamsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhub.model.ListProgressUpdateStreamsResponse =
      zio.aws.migrationhub.model.ListProgressUpdateStreamsResponse(
        progressUpdateStreamSummaryList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def progressUpdateStreamSummaryList: Option[
      List[zio.aws.migrationhub.model.ProgressUpdateStreamSummary.ReadOnly]
    ]
    def nextToken: Option[Token]
    def getProgressUpdateStreamSummaryList: ZIO[Any, AwsError, List[
      zio.aws.migrationhub.model.ProgressUpdateStreamSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "progressUpdateStreamSummaryList",
      progressUpdateStreamSummaryList
    )
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhub.model.ListProgressUpdateStreamsResponse
  ) extends zio.aws.migrationhub.model.ListProgressUpdateStreamsResponse.ReadOnly {
    override val progressUpdateStreamSummaryList: Option[
      List[zio.aws.migrationhub.model.ProgressUpdateStreamSummary.ReadOnly]
    ] = scala
      .Option(impl.progressUpdateStreamSummaryList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.migrationhub.model.ProgressUpdateStreamSummary.wrap(item)
        }.toList
      )
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.migrationhub.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhub.model.ListProgressUpdateStreamsResponse
  ): zio.aws.migrationhub.model.ListProgressUpdateStreamsResponse.ReadOnly =
    new Wrapper(impl)
}
