package zio.aws.migrationhub.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.migrationhub.model.primitives.{
  MaxResultsCreatedArtifacts,
  Token,
  MigrationTaskName,
  ProgressUpdateStream
}
import scala.jdk.CollectionConverters._
final case class ListCreatedArtifactsRequest(
    progressUpdateStream: ProgressUpdateStream,
    migrationTaskName: MigrationTaskName,
    nextToken: Option[Token] = None,
    maxResults: Option[MaxResultsCreatedArtifacts] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhub.model.ListCreatedArtifactsRequest = {
    import ListCreatedArtifactsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhub.model.ListCreatedArtifactsRequest
      .builder()
      .progressUpdateStream(
        ProgressUpdateStream.unwrap(progressUpdateStream): java.lang.String
      )
      .migrationTaskName(
        MigrationTaskName.unwrap(migrationTaskName): java.lang.String
      )
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value =>
          MaxResultsCreatedArtifacts.unwrap(value): Integer
        )
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhub.model.ListCreatedArtifactsRequest.ReadOnly =
    zio.aws.migrationhub.model.ListCreatedArtifactsRequest.wrap(buildAwsValue())
}
object ListCreatedArtifactsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhub.model.ListCreatedArtifactsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.migrationhub.model.ListCreatedArtifactsRequest =
      zio.aws.migrationhub.model.ListCreatedArtifactsRequest(
        progressUpdateStream,
        migrationTaskName,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def progressUpdateStream: ProgressUpdateStream
    def migrationTaskName: MigrationTaskName
    def nextToken: Option[Token]
    def maxResults: Option[MaxResultsCreatedArtifacts]
    def getProgressUpdateStream: ZIO[Any, Nothing, ProgressUpdateStream] =
      ZIO.succeed(progressUpdateStream)
    def getMigrationTaskName: ZIO[Any, Nothing, MigrationTaskName] =
      ZIO.succeed(migrationTaskName)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResultsCreatedArtifacts] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhub.model.ListCreatedArtifactsRequest
  ) extends zio.aws.migrationhub.model.ListCreatedArtifactsRequest.ReadOnly {
    override val progressUpdateStream: ProgressUpdateStream =
      zio.aws.migrationhub.model.primitives
        .ProgressUpdateStream(impl.progressUpdateStream())
    override val migrationTaskName: MigrationTaskName =
      zio.aws.migrationhub.model.primitives
        .MigrationTaskName(impl.migrationTaskName())
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.migrationhub.model.primitives.Token(value))
    override val maxResults: Option[MaxResultsCreatedArtifacts] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.migrationhub.model.primitives.MaxResultsCreatedArtifacts(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhub.model.ListCreatedArtifactsRequest
  ): zio.aws.migrationhub.model.ListCreatedArtifactsRequest.ReadOnly =
    new Wrapper(impl)
}
