package zio.aws.migrationhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.migrationhub.model.primitives.Token
import scala.jdk.CollectionConverters._
final case class ListMigrationTasksResponse(
    nextToken: Option[Token] = None,
    migrationTaskSummaryList: Option[
      Iterable[zio.aws.migrationhub.model.MigrationTaskSummary]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhub.model.ListMigrationTasksResponse = {
    import ListMigrationTasksResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhub.model.ListMigrationTasksResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        migrationTaskSummaryList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.migrationTaskSummaryList)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhub.model.ListMigrationTasksResponse.ReadOnly =
    zio.aws.migrationhub.model.ListMigrationTasksResponse.wrap(buildAwsValue())
}
object ListMigrationTasksResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhub.model.ListMigrationTasksResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.migrationhub.model.ListMigrationTasksResponse =
      zio.aws.migrationhub.model.ListMigrationTasksResponse(
        nextToken.map(value => value),
        migrationTaskSummaryList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[Token]
    def migrationTaskSummaryList
        : Option[List[zio.aws.migrationhub.model.MigrationTaskSummary.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMigrationTaskSummaryList: ZIO[Any, AwsError, List[
      zio.aws.migrationhub.model.MigrationTaskSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "migrationTaskSummaryList",
      migrationTaskSummaryList
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhub.model.ListMigrationTasksResponse
  ) extends zio.aws.migrationhub.model.ListMigrationTasksResponse.ReadOnly {
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.migrationhub.model.primitives.Token(value))
    override val migrationTaskSummaryList: Option[
      List[zio.aws.migrationhub.model.MigrationTaskSummary.ReadOnly]
    ] = scala
      .Option(impl.migrationTaskSummaryList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.migrationhub.model.MigrationTaskSummary.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhub.model.ListMigrationTasksResponse
  ): zio.aws.migrationhub.model.ListMigrationTasksResponse.ReadOnly =
    new Wrapper(impl)
}
