package zio.aws.migrationhub.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.migrationhub.model.primitives.{MaxResults, Token}
import scala.jdk.CollectionConverters._
final case class ListProgressUpdateStreamsRequest(
    nextToken: Option[Token] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhub.model.ListProgressUpdateStreamsRequest = {
    import ListProgressUpdateStreamsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhub.model.ListProgressUpdateStreamsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhub.model.ListProgressUpdateStreamsRequest.ReadOnly =
    zio.aws.migrationhub.model.ListProgressUpdateStreamsRequest
      .wrap(buildAwsValue())
}
object ListProgressUpdateStreamsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhub.model.ListProgressUpdateStreamsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhub.model.ListProgressUpdateStreamsRequest =
      zio.aws.migrationhub.model.ListProgressUpdateStreamsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def nextToken: Option[Token]
    def maxResults: Option[MaxResults]
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhub.model.ListProgressUpdateStreamsRequest
  ) extends zio.aws.migrationhub.model.ListProgressUpdateStreamsRequest.ReadOnly {
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.migrationhub.model.primitives.Token(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.migrationhub.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhub.model.ListProgressUpdateStreamsRequest
  ): zio.aws.migrationhub.model.ListProgressUpdateStreamsRequest.ReadOnly =
    new Wrapper(impl)
}
