package zio.aws.migrationhub.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.migrationhub.model.primitives.ApplicationId
import scala.jdk.CollectionConverters._
final case class DescribeApplicationStateRequest(applicationId: ApplicationId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhub.model.DescribeApplicationStateRequest = {
    import DescribeApplicationStateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhub.model.DescribeApplicationStateRequest
      .builder()
      .applicationId(ApplicationId.unwrap(applicationId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhub.model.DescribeApplicationStateRequest.ReadOnly =
    zio.aws.migrationhub.model.DescribeApplicationStateRequest
      .wrap(buildAwsValue())
}
object DescribeApplicationStateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhub.model.DescribeApplicationStateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.migrationhub.model.DescribeApplicationStateRequest =
      zio.aws.migrationhub.model.DescribeApplicationStateRequest(applicationId)
    def applicationId: ApplicationId
    def getApplicationId: ZIO[Any, Nothing, ApplicationId] =
      ZIO.succeed(applicationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhub.model.DescribeApplicationStateRequest
  ) extends zio.aws.migrationhub.model.DescribeApplicationStateRequest.ReadOnly {
    override val applicationId: ApplicationId =
      zio.aws.migrationhub.model.primitives.ApplicationId(impl.applicationId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhub.model.DescribeApplicationStateRequest
  ): zio.aws.migrationhub.model.DescribeApplicationStateRequest.ReadOnly =
    new Wrapper(impl)
}
