package zio.aws.migrationhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.migrationhub.model.primitives.{DryRun, ProgressUpdateStream}
import scala.jdk.CollectionConverters._
final case class CreateProgressUpdateStreamRequest(
    progressUpdateStreamName: ProgressUpdateStream,
    dryRun: Option[DryRun] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhub.model.CreateProgressUpdateStreamRequest = {
    import CreateProgressUpdateStreamRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhub.model.CreateProgressUpdateStreamRequest
      .builder()
      .progressUpdateStreamName(
        ProgressUpdateStream.unwrap(progressUpdateStreamName): java.lang.String
      )
      .optionallyWith(
        dryRun.map(value => DryRun.unwrap(value): java.lang.Boolean)
      )(_.dryRun)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhub.model.CreateProgressUpdateStreamRequest.ReadOnly =
    zio.aws.migrationhub.model.CreateProgressUpdateStreamRequest
      .wrap(buildAwsValue())
}
object CreateProgressUpdateStreamRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhub.model.CreateProgressUpdateStreamRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhub.model.CreateProgressUpdateStreamRequest =
      zio.aws.migrationhub.model.CreateProgressUpdateStreamRequest(
        progressUpdateStreamName,
        dryRun.map(value => value)
      )
    def progressUpdateStreamName: ProgressUpdateStream
    def dryRun: Option[DryRun]
    def getProgressUpdateStreamName: ZIO[Any, Nothing, ProgressUpdateStream] =
      ZIO.succeed(progressUpdateStreamName)
    def getDryRun: ZIO[Any, AwsError, DryRun] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhub.model.CreateProgressUpdateStreamRequest
  ) extends zio.aws.migrationhub.model.CreateProgressUpdateStreamRequest.ReadOnly {
    override val progressUpdateStreamName: ProgressUpdateStream =
      zio.aws.migrationhub.model.primitives
        .ProgressUpdateStream(impl.progressUpdateStreamName())
    override val dryRun: Option[DryRun] = scala
      .Option(impl.dryRun())
      .map(value => zio.aws.migrationhub.model.primitives.DryRun(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhub.model.CreateProgressUpdateStreamRequest
  ): zio.aws.migrationhub.model.CreateProgressUpdateStreamRequest.ReadOnly =
    new Wrapper(impl)
}
