package zio.aws.migrationhub.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.migrationhub.model.primitives.{ProgressPercent, StatusDetail}
import scala.jdk.CollectionConverters._
final case class Task(
    status: zio.aws.migrationhub.model.Status,
    statusDetail: Option[StatusDetail] = None,
    progressPercent: Option[ProgressPercent] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhub.model.Task = {
    import Task.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhub.model.Task
      .builder()
      .status(status.unwrap)
      .optionallyWith(
        statusDetail.map(value => StatusDetail.unwrap(value): java.lang.String)
      )(_.statusDetail)
      .optionallyWith(
        progressPercent.map(value => ProgressPercent.unwrap(value): Integer)
      )(_.progressPercent)
      .build()
  }
  def asReadOnly: zio.aws.migrationhub.model.Task.ReadOnly =
    zio.aws.migrationhub.model.Task.wrap(buildAwsValue())
}
object Task {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.migrationhub.model.Task] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.migrationhub.model.Task =
      zio.aws.migrationhub.model.Task(
        status,
        statusDetail.map(value => value),
        progressPercent.map(value => value)
      )
    def status: zio.aws.migrationhub.model.Status
    def statusDetail: Option[StatusDetail]
    def progressPercent: Option[ProgressPercent]
    def getStatus: ZIO[Any, Nothing, zio.aws.migrationhub.model.Status] =
      ZIO.succeed(status)
    def getStatusDetail: ZIO[Any, AwsError, StatusDetail] =
      AwsError.unwrapOptionField("statusDetail", statusDetail)
    def getProgressPercent: ZIO[Any, AwsError, ProgressPercent] =
      AwsError.unwrapOptionField("progressPercent", progressPercent)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhub.model.Task
  ) extends zio.aws.migrationhub.model.Task.ReadOnly {
    override val status: zio.aws.migrationhub.model.Status =
      zio.aws.migrationhub.model.Status.wrap(impl.status())
    override val statusDetail: Option[StatusDetail] = scala
      .Option(impl.statusDetail())
      .map(value => zio.aws.migrationhub.model.primitives.StatusDetail(value))
    override val progressPercent: Option[ProgressPercent] = scala
      .Option(impl.progressPercent())
      .map(value =>
        zio.aws.migrationhub.model.primitives.ProgressPercent(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhub.model.Task
  ): zio.aws.migrationhub.model.Task.ReadOnly = new Wrapper(impl)
}
