package zio.aws.migrationhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.migrationhub.model.primitives.{
  DryRun,
  CreatedArtifactName,
  MigrationTaskName,
  ProgressUpdateStream
}
import scala.jdk.CollectionConverters._
final case class DisassociateCreatedArtifactRequest(
    progressUpdateStream: ProgressUpdateStream,
    migrationTaskName: MigrationTaskName,
    createdArtifactName: CreatedArtifactName,
    dryRun: Option[DryRun] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhub.model.DisassociateCreatedArtifactRequest = {
    import DisassociateCreatedArtifactRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhub.model.DisassociateCreatedArtifactRequest
      .builder()
      .progressUpdateStream(
        ProgressUpdateStream.unwrap(progressUpdateStream): java.lang.String
      )
      .migrationTaskName(
        MigrationTaskName.unwrap(migrationTaskName): java.lang.String
      )
      .createdArtifactName(
        CreatedArtifactName.unwrap(createdArtifactName): java.lang.String
      )
      .optionallyWith(
        dryRun.map(value => DryRun.unwrap(value): java.lang.Boolean)
      )(_.dryRun)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhub.model.DisassociateCreatedArtifactRequest.ReadOnly =
    zio.aws.migrationhub.model.DisassociateCreatedArtifactRequest
      .wrap(buildAwsValue())
}
object DisassociateCreatedArtifactRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhub.model.DisassociateCreatedArtifactRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhub.model.DisassociateCreatedArtifactRequest =
      zio.aws.migrationhub.model.DisassociateCreatedArtifactRequest(
        progressUpdateStream,
        migrationTaskName,
        createdArtifactName,
        dryRun.map(value => value)
      )
    def progressUpdateStream: ProgressUpdateStream
    def migrationTaskName: MigrationTaskName
    def createdArtifactName: CreatedArtifactName
    def dryRun: Option[DryRun]
    def getProgressUpdateStream: ZIO[Any, Nothing, ProgressUpdateStream] =
      ZIO.succeed(progressUpdateStream)
    def getMigrationTaskName: ZIO[Any, Nothing, MigrationTaskName] =
      ZIO.succeed(migrationTaskName)
    def getCreatedArtifactName: ZIO[Any, Nothing, CreatedArtifactName] =
      ZIO.succeed(createdArtifactName)
    def getDryRun: ZIO[Any, AwsError, DryRun] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhub.model.DisassociateCreatedArtifactRequest
  ) extends zio.aws.migrationhub.model.DisassociateCreatedArtifactRequest.ReadOnly {
    override val progressUpdateStream: ProgressUpdateStream =
      zio.aws.migrationhub.model.primitives
        .ProgressUpdateStream(impl.progressUpdateStream())
    override val migrationTaskName: MigrationTaskName =
      zio.aws.migrationhub.model.primitives
        .MigrationTaskName(impl.migrationTaskName())
    override val createdArtifactName: CreatedArtifactName =
      zio.aws.migrationhub.model.primitives
        .CreatedArtifactName(impl.createdArtifactName())
    override val dryRun: Option[DryRun] = scala
      .Option(impl.dryRun())
      .map(value => zio.aws.migrationhub.model.primitives.DryRun(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhub.model.DisassociateCreatedArtifactRequest
  ): zio.aws.migrationhub.model.DisassociateCreatedArtifactRequest.ReadOnly =
    new Wrapper(impl)
}
