package zio.aws.migrationhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.migrationhub.model.primitives.{
  UpdateDateTime,
  MigrationTaskName,
  ProgressUpdateStream
}
import scala.jdk.CollectionConverters._
final case class MigrationTask(
    progressUpdateStream: Option[ProgressUpdateStream] = None,
    migrationTaskName: Option[MigrationTaskName] = None,
    task: Option[zio.aws.migrationhub.model.Task] = None,
    updateDateTime: Option[UpdateDateTime] = None,
    resourceAttributeList: Option[
      Iterable[zio.aws.migrationhub.model.ResourceAttribute]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhub.model.MigrationTask = {
    import MigrationTask.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhub.model.MigrationTask
      .builder()
      .optionallyWith(
        progressUpdateStream.map(value =>
          ProgressUpdateStream.unwrap(value): java.lang.String
        )
      )(_.progressUpdateStream)
      .optionallyWith(
        migrationTaskName.map(value =>
          MigrationTaskName.unwrap(value): java.lang.String
        )
      )(_.migrationTaskName)
      .optionallyWith(task.map(value => value.buildAwsValue()))(_.task)
      .optionallyWith(
        updateDateTime.map(value => UpdateDateTime.unwrap(value): Instant)
      )(_.updateDateTime)
      .optionallyWith(
        resourceAttributeList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceAttributeList)
      .build()
  }
  def asReadOnly: zio.aws.migrationhub.model.MigrationTask.ReadOnly =
    zio.aws.migrationhub.model.MigrationTask.wrap(buildAwsValue())
}
object MigrationTask {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhub.model.MigrationTask
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.migrationhub.model.MigrationTask =
      zio.aws.migrationhub.model.MigrationTask(
        progressUpdateStream.map(value => value),
        migrationTaskName.map(value => value),
        task.map(value => value.asEditable),
        updateDateTime.map(value => value),
        resourceAttributeList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def progressUpdateStream: Option[ProgressUpdateStream]
    def migrationTaskName: Option[MigrationTaskName]
    def task: Option[zio.aws.migrationhub.model.Task.ReadOnly]
    def updateDateTime: Option[UpdateDateTime]
    def resourceAttributeList
        : Option[List[zio.aws.migrationhub.model.ResourceAttribute.ReadOnly]]
    def getProgressUpdateStream: ZIO[Any, AwsError, ProgressUpdateStream] =
      AwsError.unwrapOptionField("progressUpdateStream", progressUpdateStream)
    def getMigrationTaskName: ZIO[Any, AwsError, MigrationTaskName] =
      AwsError.unwrapOptionField("migrationTaskName", migrationTaskName)
    def getTask: ZIO[Any, AwsError, zio.aws.migrationhub.model.Task.ReadOnly] =
      AwsError.unwrapOptionField("task", task)
    def getUpdateDateTime: ZIO[Any, AwsError, UpdateDateTime] =
      AwsError.unwrapOptionField("updateDateTime", updateDateTime)
    def getResourceAttributeList: ZIO[Any, AwsError, List[
      zio.aws.migrationhub.model.ResourceAttribute.ReadOnly
    ]] =
      AwsError.unwrapOptionField("resourceAttributeList", resourceAttributeList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhub.model.MigrationTask
  ) extends zio.aws.migrationhub.model.MigrationTask.ReadOnly {
    override val progressUpdateStream: Option[ProgressUpdateStream] = scala
      .Option(impl.progressUpdateStream())
      .map(value =>
        zio.aws.migrationhub.model.primitives.ProgressUpdateStream(value)
      )
    override val migrationTaskName: Option[MigrationTaskName] = scala
      .Option(impl.migrationTaskName())
      .map(value =>
        zio.aws.migrationhub.model.primitives.MigrationTaskName(value)
      )
    override val task: Option[zio.aws.migrationhub.model.Task.ReadOnly] = scala
      .Option(impl.task())
      .map(value => zio.aws.migrationhub.model.Task.wrap(value))
    override val updateDateTime: Option[UpdateDateTime] = scala
      .Option(impl.updateDateTime())
      .map(value => zio.aws.migrationhub.model.primitives.UpdateDateTime(value))
    override val resourceAttributeList
        : Option[List[zio.aws.migrationhub.model.ResourceAttribute.ReadOnly]] =
      scala
        .Option(impl.resourceAttributeList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.migrationhub.model.ResourceAttribute.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhub.model.MigrationTask
  ): zio.aws.migrationhub.model.MigrationTask.ReadOnly = new Wrapper(impl)
}
