package zio.aws.migrationhub.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.migrationhub.model.primitives.{
  MaxResultsResources,
  Token,
  MigrationTaskName,
  ProgressUpdateStream
}
import scala.jdk.CollectionConverters._
final case class ListDiscoveredResourcesRequest(
    progressUpdateStream: ProgressUpdateStream,
    migrationTaskName: MigrationTaskName,
    nextToken: Option[Token] = None,
    maxResults: Option[MaxResultsResources] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhub.model.ListDiscoveredResourcesRequest = {
    import ListDiscoveredResourcesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhub.model.ListDiscoveredResourcesRequest
      .builder()
      .progressUpdateStream(
        ProgressUpdateStream.unwrap(progressUpdateStream): java.lang.String
      )
      .migrationTaskName(
        MigrationTaskName.unwrap(migrationTaskName): java.lang.String
      )
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResultsResources.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhub.model.ListDiscoveredResourcesRequest.ReadOnly =
    zio.aws.migrationhub.model.ListDiscoveredResourcesRequest
      .wrap(buildAwsValue())
}
object ListDiscoveredResourcesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhub.model.ListDiscoveredResourcesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.migrationhub.model.ListDiscoveredResourcesRequest =
      zio.aws.migrationhub.model.ListDiscoveredResourcesRequest(
        progressUpdateStream,
        migrationTaskName,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def progressUpdateStream: ProgressUpdateStream
    def migrationTaskName: MigrationTaskName
    def nextToken: Option[Token]
    def maxResults: Option[MaxResultsResources]
    def getProgressUpdateStream: ZIO[Any, Nothing, ProgressUpdateStream] =
      ZIO.succeed(progressUpdateStream)
    def getMigrationTaskName: ZIO[Any, Nothing, MigrationTaskName] =
      ZIO.succeed(migrationTaskName)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResultsResources] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhub.model.ListDiscoveredResourcesRequest
  ) extends zio.aws.migrationhub.model.ListDiscoveredResourcesRequest.ReadOnly {
    override val progressUpdateStream: ProgressUpdateStream =
      zio.aws.migrationhub.model.primitives
        .ProgressUpdateStream(impl.progressUpdateStream())
    override val migrationTaskName: MigrationTaskName =
      zio.aws.migrationhub.model.primitives
        .MigrationTaskName(impl.migrationTaskName())
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.migrationhub.model.primitives.Token(value))
    override val maxResults: Option[MaxResultsResources] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.migrationhub.model.primitives.MaxResultsResources(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhub.model.ListDiscoveredResourcesRequest
  ): zio.aws.migrationhub.model.ListDiscoveredResourcesRequest.ReadOnly =
    new Wrapper(impl)
}
