package zio.aws.migrationhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeMigrationTaskResponse(
    migrationTask: Option[zio.aws.migrationhub.model.MigrationTask] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhub.model.DescribeMigrationTaskResponse = {
    import DescribeMigrationTaskResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhub.model.DescribeMigrationTaskResponse
      .builder()
      .optionallyWith(migrationTask.map(value => value.buildAwsValue()))(
        _.migrationTask
      )
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhub.model.DescribeMigrationTaskResponse.ReadOnly =
    zio.aws.migrationhub.model.DescribeMigrationTaskResponse
      .wrap(buildAwsValue())
}
object DescribeMigrationTaskResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhub.model.DescribeMigrationTaskResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.migrationhub.model.DescribeMigrationTaskResponse =
      zio.aws.migrationhub.model.DescribeMigrationTaskResponse(
        migrationTask.map(value => value.asEditable)
      )
    def migrationTask: Option[zio.aws.migrationhub.model.MigrationTask.ReadOnly]
    def getMigrationTask: ZIO[
      Any,
      AwsError,
      zio.aws.migrationhub.model.MigrationTask.ReadOnly
    ] = AwsError.unwrapOptionField("migrationTask", migrationTask)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhub.model.DescribeMigrationTaskResponse
  ) extends zio.aws.migrationhub.model.DescribeMigrationTaskResponse.ReadOnly {
    override val migrationTask
        : Option[zio.aws.migrationhub.model.MigrationTask.ReadOnly] = scala
      .Option(impl.migrationTask())
      .map(value => zio.aws.migrationhub.model.MigrationTask.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhub.model.DescribeMigrationTaskResponse
  ): zio.aws.migrationhub.model.DescribeMigrationTaskResponse.ReadOnly =
    new Wrapper(impl)
}
