package zio.aws.migrationhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.migrationhub.model.primitives.{DryRun, ProgressUpdateStream}
import scala.jdk.CollectionConverters._
final case class DeleteProgressUpdateStreamRequest(
    progressUpdateStreamName: ProgressUpdateStream,
    dryRun: Option[DryRun] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhub.model.DeleteProgressUpdateStreamRequest = {
    import DeleteProgressUpdateStreamRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhub.model.DeleteProgressUpdateStreamRequest
      .builder()
      .progressUpdateStreamName(
        ProgressUpdateStream.unwrap(progressUpdateStreamName): java.lang.String
      )
      .optionallyWith(
        dryRun.map(value => DryRun.unwrap(value): java.lang.Boolean)
      )(_.dryRun)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhub.model.DeleteProgressUpdateStreamRequest.ReadOnly =
    zio.aws.migrationhub.model.DeleteProgressUpdateStreamRequest
      .wrap(buildAwsValue())
}
object DeleteProgressUpdateStreamRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhub.model.DeleteProgressUpdateStreamRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhub.model.DeleteProgressUpdateStreamRequest =
      zio.aws.migrationhub.model.DeleteProgressUpdateStreamRequest(
        progressUpdateStreamName,
        dryRun.map(value => value)
      )
    def progressUpdateStreamName: ProgressUpdateStream
    def dryRun: Option[DryRun]
    def getProgressUpdateStreamName: ZIO[Any, Nothing, ProgressUpdateStream] =
      ZIO.succeed(progressUpdateStreamName)
    def getDryRun: ZIO[Any, AwsError, DryRun] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhub.model.DeleteProgressUpdateStreamRequest
  ) extends zio.aws.migrationhub.model.DeleteProgressUpdateStreamRequest.ReadOnly {
    override val progressUpdateStreamName: ProgressUpdateStream =
      zio.aws.migrationhub.model.primitives
        .ProgressUpdateStream(impl.progressUpdateStreamName())
    override val dryRun: Option[DryRun] = scala
      .Option(impl.dryRun())
      .map(value => zio.aws.migrationhub.model.primitives.DryRun(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhub.model.DeleteProgressUpdateStreamRequest
  ): zio.aws.migrationhub.model.DeleteProgressUpdateStreamRequest.ReadOnly =
    new Wrapper(impl)
}
